/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateAverageAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountAggregation;
import com.facebook.presto.operator.aggregation.ApproximateCountColumnAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregations;
import com.facebook.presto.operator.aggregation.ApproximateDoubleSumAggregation;
import com.facebook.presto.operator.aggregation.ApproximateLongSumAggregation;
import com.facebook.presto.operator.aggregation.ApproximatePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximatePercentileWeightedAggregations;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.BooleanMaxAggregation;
import com.facebook.presto.operator.aggregation.BooleanMinAggregation;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.CountColumnAggregations;
import com.facebook.presto.operator.aggregation.CountIfAggregation;
import com.facebook.presto.operator.aggregation.DoubleMaxAggregation;
import com.facebook.presto.operator.aggregation.DoubleMinAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.HyperLogLogAggregations;
import com.facebook.presto.operator.aggregation.LongMaxAggregation;
import com.facebook.presto.operator.aggregation.LongMinAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMaxAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMinAggregation;
import com.facebook.presto.operator.aggregation.VarianceAggregations;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.HyperLogLogFunctions;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.RegexpFunctions;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.operator.scalar.UrlFunctions;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.operator.window.CumulativeDistributionFunction;
import com.facebook.presto.operator.window.DenseRankFunction;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.PercentRankFunction;
import com.facebook.presto.operator.window.RankFunction;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.DefaultFunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.DateOperators;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.IntervalDayTimeOperators;
import com.facebook.presto.type.IntervalYearMonthOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.type.TimeOperators;
import com.facebook.presto.type.TimeWithTimeZoneOperators;
import com.facebook.presto.type.TimestampOperators;
import com.facebook.presto.type.TimestampWithTimeZoneOperators;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarbinaryOperators;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private static final String MAGIC_LITERAL_FUNCTION_PREFIX = "$literal$";
    private final TypeManager typeManager;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(TypeManager typeManager, boolean experimentalSyntaxEnabled) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        FunctionListBuilder builder = new FunctionListBuilder().window("row_number", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RowNumberFunction.class).window("rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RankFunction.class).window("dense_rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), DenseRankFunction.class).window("percent_rank", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), PercentRankFunction.class).window("cume_dist", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), CumulativeDistributionFunction.class).window("first_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), FirstValueFunction.BigintFirstValueFunction.class).window("first_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), FirstValueFunction.DoubleFirstValueFunction.class).window("first_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), FirstValueFunction.BooleanFirstValueFunction.class).window("first_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), FirstValueFunction.VarcharFirstValueFunction.class).window("last_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), LastValueFunction.BigintLastValueFunction.class).window("last_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), LastValueFunction.DoubleLastValueFunction.class).window("last_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), LastValueFunction.BooleanLastValueFunction.class).window("last_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), LastValueFunction.VarcharLastValueFunction.class).window("nth_value", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), NthValueFunction.BigintNthValueFunction.class).window("nth_value", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), NthValueFunction.DoubleNthValueFunction.class).window("nth_value", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT), NthValueFunction.BooleanNthValueFunction.class).window("nth_value", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), NthValueFunction.VarcharNthValueFunction.class).aggregate("count", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), (Type)BigintType.BIGINT, CountAggregation.COUNT).aggregate("count", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)BigintType.BIGINT, CountColumnAggregations.COUNT_BOOLEAN_COLUMN).aggregate("count", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, CountColumnAggregations.COUNT_LONG_COLUMN).aggregate("count", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)BigintType.BIGINT, CountColumnAggregations.COUNT_DOUBLE_COLUMN).aggregate("count", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)BigintType.BIGINT, CountColumnAggregations.COUNT_STRING_COLUMN).aggregate("count_if", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)BigintType.BIGINT, CountIfAggregation.COUNT_IF).aggregate("sum", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, LongSumAggregation.LONG_SUM).aggregate("sum", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE, DoubleSumAggregation.DOUBLE_SUM).aggregate("avg", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, AverageAggregations.DOUBLE_AVERAGE).aggregate("avg", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, AverageAggregations.LONG_AVERAGE).aggregate("max", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)BooleanType.BOOLEAN, BooleanMaxAggregation.BOOLEAN_MAX).aggregate("max", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, LongMaxAggregation.LONG_MAX).aggregate("max", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE, DoubleMaxAggregation.DOUBLE_MAX).aggregate("max", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, VarBinaryMaxAggregation.VAR_BINARY_MAX).aggregate("min", (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)BooleanType.BOOLEAN, BooleanMinAggregation.BOOLEAN_MIN).aggregate("min", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, LongMinAggregation.LONG_MIN).aggregate("min", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE, DoubleMinAggregation.DOUBLE_MIN).aggregate("min", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, VarBinaryMinAggregation.VAR_BINARY_MIN).aggregate("var_pop", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_POP_INSTANCE).aggregate("var_pop", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_VARIANCE_POP_INSTANCE).aggregate("var_samp", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_INSTANCE).aggregate("var_samp", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_VARIANCE_INSTANCE).aggregate("variance", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_VARIANCE_INSTANCE).aggregate("variance", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_VARIANCE_INSTANCE).aggregate("stddev_pop", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_POP_INSTANCE).aggregate("stddev_pop", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_STDDEV_POP_INSTANCE).aggregate("stddev_samp", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_INSTANCE).aggregate("stddev_samp", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_STDDEV_INSTANCE).aggregate("stddev", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, VarianceAggregations.DOUBLE_STDDEV_INSTANCE).aggregate("stddev", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, VarianceAggregations.LONG_STDDEV_INSTANCE).aggregate("approx_distinct", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)VarcharType.VARCHAR, ApproximateCountDistinctAggregations.LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, ApproximateCountDistinctAggregations.LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximateCountDistinctAggregations.DOUBLE_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_distinct", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, ApproximateCountDistinctAggregations.VARBINARY_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS).aggregate("approx_set", (Type)HyperLogLogType.HYPER_LOG_LOG, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)HyperLogLogType.HYPER_LOG_LOG, HyperLogLogAggregations.BIGINT_APPROXIMATE_SET_AGGREGATION).aggregate("approx_set", (Type)HyperLogLogType.HYPER_LOG_LOG, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)HyperLogLogType.HYPER_LOG_LOG, HyperLogLogAggregations.VARCHAR_APPROXIMATE_SET_AGGREGATION).aggregate("approx_set", (Type)HyperLogLogType.HYPER_LOG_LOG, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)HyperLogLogType.HYPER_LOG_LOG, HyperLogLogAggregations.DOUBLE_APPROXIMATE_SET_AGGREGATION).aggregate("merge", (Type)HyperLogLogType.HYPER_LOG_LOG, (List<? extends Type>)ImmutableList.of((Object)HyperLogLogType.HYPER_LOG_LOG), (Type)HyperLogLogType.HYPER_LOG_LOG, HyperLogLogAggregations.MERGE_HYPER_LOG_LOG_AGGREGATION).aggregate("approx_percentile", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximatePercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION).aggregate("approx_percentile", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximatePercentileWeightedAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION).aggregate("approx_percentile", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximatePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION).aggregate("approx_percentile", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximatePercentileWeightedAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION).aggregate("approx_avg", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, ApproximateAverageAggregations.LONG_APPROXIMATE_AVERAGE_AGGREGATION).aggregate("approx_avg", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximateAverageAggregations.DOUBLE_APPROXIMATE_AVERAGE_AGGREGATION).scalar(StringFunctions.class).scalar(VarbinaryFunctions.class).scalar(RegexpFunctions.class).scalar(UrlFunctions.class).scalar(MathFunctions.class).scalar(DateTimeFunctions.class).scalar(JsonFunctions.class).scalar(ColorFunctions.class).scalar(HyperLogLogFunctions.class).scalar(BooleanOperators.class).scalar(BigintOperators.class).scalar(DoubleOperators.class).scalar(VarcharOperators.class).scalar(VarbinaryOperators.class).scalar(DateOperators.class).scalar(TimeOperators.class).scalar(TimestampOperators.class).scalar(IntervalDayTimeOperators.class).scalar(IntervalYearMonthOperators.class).scalar(TimeWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.class).scalar(DateTimeOperators.class);
        if (experimentalSyntaxEnabled) {
            builder.approximateAggregate("avg", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, ApproximateAverageAggregations.LONG_APPROXIMATE_AVERAGE_AGGREGATION).approximateAggregate("avg", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximateAverageAggregations.DOUBLE_APPROXIMATE_AVERAGE_AGGREGATION).approximateAggregate("sum", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, ApproximateLongSumAggregation.LONG_APPROXIMATE_SUM_AGGREGATION).approximateAggregate("sum", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximateDoubleSumAggregation.DOUBLE_APPROXIMATE_SUM_AGGREGATION).approximateAggregate("count", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of(), (Type)VarcharType.VARCHAR, ApproximateCountAggregation.APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)BooleanType.BOOLEAN), (Type)VarcharType.VARCHAR, ApproximateCountColumnAggregations.BOOLEAN_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)VarcharType.VARCHAR, ApproximateCountColumnAggregations.LONG_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)VarcharType.VARCHAR, ApproximateCountColumnAggregations.DOUBLE_APPROXIMATE_COUNT_AGGREGATION).approximateAggregate("count", (Type)VarcharType.VARCHAR, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)VarcharType.VARCHAR, ApproximateCountColumnAggregations.VARBINARY_APPROXIMATE_COUNT_AGGREGATION);
        }
        this.addFunctions(builder.getFunctions(), builder.getOperators());
    }

    public final synchronized void addFunctions(List<FunctionInfo> functions, Multimap<OperatorType, FunctionInfo> operators) {
        for (FunctionInfo function : functions) {
            Preconditions.checkArgument((this.functions.get(function.getSignature()) == null ? 1 : 0) != 0, (String)"Function already registered: %s", (Object[])new Object[]{function.getSignature()});
        }
        this.functions = new FunctionMap(this.functions, functions, operators);
    }

    public List<FunctionInfo> list() {
        return FluentIterable.from(this.functions.list()).filter(Predicates.not(FunctionInfo.isHiddenPredicate())).toList();
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return Iterables.any(this.functions.get(name), FunctionInfo.isAggregationPredicate());
    }

    public FunctionInfo resolveFunction(QualifiedName name, List<? extends Type> parameterTypes, final boolean approximate) {
        List<FunctionInfo> candidates = IterableTransformer.on(this.functions.get(name)).select(new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo input) {
                return input.isScalar() || input.isApproximate() == approximate;
            }
        }).list();
        for (FunctionInfo functionInfo : candidates) {
            if (!functionInfo.getArgumentTypes().equals(parameterTypes)) continue;
            return functionInfo;
        }
        for (FunctionInfo functionInfo : candidates) {
            if (!FunctionRegistry.canCoerce(parameterTypes, functionInfo.getArgumentTypes())) continue;
            return functionInfo;
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (FunctionInfo functionInfo : candidates) {
            expectedParameters.add(String.format("%s(%s)", name, Joiner.on((String)", ").join(functionInfo.getArgumentTypes())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        if (name.getSuffix().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            String typeName = name.getSuffix().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(typeName);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Type %s not registered", (Object[])new Object[]{typeName});
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", (Object[])new Object[]{parameterTypes});
            Type parameterType = parameterTypes.get(0);
            Preconditions.checkArgument((parameterType.getJavaType() == type.getJavaType() ? 1 : 0) != 0, (String)"Expected type %s to use Java type %s, but Java type is %s", (Object[])new Object[]{type, parameterType.getJavaType(), type.getJavaType()});
            MethodHandle identity = MethodHandles.identity(parameterTypes.get(0).getJavaType());
            return new FunctionInfo(new Signature(MAGIC_LITERAL_FUNCTION_PREFIX, type, (List<? extends Type>)ImmutableList.copyOf(parameterTypes), false), null, true, identity, true, new DefaultFunctionBinder(identity, false));
        }
        throw new PrestoException(StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode(), message);
    }

    public FunctionInfo getExactFunction(Signature signature) {
        return this.functions.get(signature);
    }

    public FunctionInfo resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        Collection<FunctionInfo> candidates = this.functions.getOperators(operatorType);
        for (FunctionInfo operatorInfo : candidates) {
            if (!operatorInfo.getArgumentTypes().equals(argumentTypes)) continue;
            return operatorInfo;
        }
        for (FunctionInfo operatorInfo : candidates) {
            if (!FunctionRegistry.canCoerce(argumentTypes, operatorInfo.getArgumentTypes())) continue;
            return operatorInfo;
        }
        throw new OperatorNotFoundException(operatorType, argumentTypes);
    }

    public FunctionInfo getExactOperator(OperatorType operatorType, List<? extends Type> argumentTypes, Type returnType) throws OperatorNotFoundException {
        Collection<FunctionInfo> candidates = this.functions.getOperators(operatorType);
        for (FunctionInfo operatorInfo : candidates) {
            if (!operatorInfo.getReturnType().equals(returnType) || !operatorInfo.getArgumentTypes().equals(argumentTypes)) continue;
            return operatorInfo;
        }
        if (operatorType == OperatorType.CAST && argumentTypes.size() == 1 && argumentTypes.get(0).equals(returnType)) {
            MethodHandle identity = MethodHandles.identity(returnType.getJavaType());
            return FunctionRegistry.operatorInfo(OperatorType.CAST, returnType, argumentTypes, identity, new DefaultFunctionBinder(identity, false));
        }
        throw new OperatorNotFoundException(operatorType, argumentTypes, returnType);
    }

    public static boolean canCoerce(List<? extends Type> actualTypes, List<Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            Type expectedType = expectedTypes.get(i);
            Type actualType = actualTypes.get(i);
            if (FunctionRegistry.canCoerce(actualType, expectedType)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCoerce(Type actualType, Type expectedType) {
        if (expectedType.equals(actualType)) {
            return true;
        }
        if (actualType.equals(UnknownType.UNKNOWN)) {
            return true;
        }
        if (actualType.equals(BigintType.BIGINT) && expectedType.equals(DoubleType.DOUBLE)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampType.TIMESTAMP)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(TimeType.TIME) && expectedType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return true;
        }
        return actualType.equals(TimestampType.TIMESTAMP) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    }

    public static Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        if (firstType.equals(UnknownType.UNKNOWN)) {
            return Optional.of((Object)secondType);
        }
        if (secondType.equals(UnknownType.UNKNOWN)) {
            return Optional.of((Object)firstType);
        }
        if (firstType.equals(secondType)) {
            return Optional.of((Object)firstType);
        }
        if ((firstType.equals(BigintType.BIGINT) || firstType.equals(DoubleType.DOUBLE)) && (secondType.equals(BigintType.BIGINT) || secondType.equals(DoubleType.DOUBLE))) {
            return Optional.of((Object)DoubleType.DOUBLE);
        }
        if ((firstType.equals(TimeType.TIME) || firstType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) && (secondType.equals(TimeType.TIME) || secondType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE))) {
            return Optional.of((Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        }
        if ((firstType.equals(TimestampType.TIMESTAMP) || firstType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) && (secondType.equals(TimestampType.TIMESTAMP) || secondType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
            return Optional.of((Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        }
        return Optional.absent();
    }

    private static List<Type> parameterTypes(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ImmutableList.Builder types = ImmutableList.builder();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> clazz = method.getParameterTypes()[i];
            if (clazz == ConnectorSession.class) continue;
            SqlType explicitType = null;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof SqlType)) continue;
                explicitType = (SqlType)annotation;
                break;
            }
            Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s argument %s does not have a @SqlType annotation", (Object[])new Object[]{method, i});
            types.add((Object)FunctionRegistry.type(explicitType));
        }
        return types.build();
    }

    private static List<Class<?>> getParameterTypes(Class<?> ... types) {
        ImmutableList parameterTypes = ImmutableList.copyOf((Object[])types);
        if (!parameterTypes.isEmpty() && parameterTypes.get(0) == ConnectorSession.class) {
            parameterTypes = parameterTypes.subList(1, parameterTypes.size());
        }
        return parameterTypes;
    }

    private static Type type(SqlType explicitType) {
        try {
            return (Type)explicitType.value().getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Type type(Class<?> clazz) {
        if ((clazz = Primitives.unwrap(clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (clazz == Slice.class) {
            return VarcharType.VARCHAR;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }

    public static Signature getMagicLiteralFunctionSignature(Type type) {
        return new Signature(MAGIC_LITERAL_FUNCTION_PREFIX + type.getName(), type, (List<? extends Type>)ImmutableList.of((Object)FunctionRegistry.type(type.getJavaType())), false);
    }

    private static FunctionInfo operatorInfo(OperatorType operatorType, Type returnType, List<? extends Type> argumentTypes, MethodHandle method, FunctionBinder functionBinder) {
        operatorType.validateSignature(returnType, (List<Type>)ImmutableList.copyOf(argumentTypes));
        Signature signature = new Signature(operatorType.name(), returnType, argumentTypes, false, true);
        return new FunctionInfo(signature, operatorType.getOperator(), true, method, true, functionBinder);
    }

    private static void verifyMethodSignature(Method method, Type returnType, List<Type> argumentTypes) {
        Preconditions.checkArgument((Primitives.unwrap(method.getReturnType()) == returnType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s return type to be %s (%s)", (Object[])new Object[]{method, returnType.getJavaType().getName(), returnType});
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0 && parameterTypes[0] == ConnectorSession.class) {
            parameterTypes = Arrays.copyOfRange(parameterTypes, 1, parameterTypes.length);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> actualType = parameterTypes[i];
            Type expectedType = argumentTypes.get(i);
            Preconditions.checkArgument((Primitives.unwrap(actualType) == expectedType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s parameter %s type to be %s (%s)", (Object[])new Object[]{method, i, expectedType.getJavaType().getName(), expectedType});
        }
    }

    private static class FunctionMap {
        private final Multimap<QualifiedName, FunctionInfo> functionsByName;
        private final Map<Signature, FunctionInfo> functionsBySignature;
        private final Multimap<OperatorType, FunctionInfo> byOperator;

        public FunctionMap() {
            this.functionsByName = ImmutableListMultimap.of();
            this.functionsBySignature = ImmutableMap.of();
            this.byOperator = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<FunctionInfo> functions, Multimap<OperatorType, FunctionInfo> operators) {
            this.functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByName).putAll((Multimap)Multimaps.index(functions, FunctionInfo.nameGetter())).build();
            this.functionsBySignature = ImmutableMap.builder().putAll(map.functionsBySignature).putAll((Map)Maps.uniqueIndex(functions, FunctionInfo.handleGetter())).build();
            this.byOperator = ImmutableListMultimap.builder().putAll(map.byOperator).putAll(operators).build();
            for (Map.Entry entry : this.functionsByName.asMap().entrySet()) {
                Collection infos = (Collection)entry.getValue();
                Preconditions.checkState((Iterables.all((Iterable)infos, FunctionInfo.isAggregationPredicate()) || !Iterables.any((Iterable)infos, FunctionInfo.isAggregationPredicate()) ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", (Object[])new Object[]{entry.getKey()});
            }
        }

        public List<FunctionInfo> list() {
            return ImmutableList.copyOf((Collection)this.functionsByName.values());
        }

        public Collection<FunctionInfo> get(QualifiedName name) {
            return this.functionsByName.get((Object)name);
        }

        public FunctionInfo get(Signature signature) {
            return this.functionsBySignature.get(signature);
        }

        public Collection<FunctionInfo> getOperators(OperatorType operatorType) {
            return this.byOperator.get((Object)operatorType);
        }
    }

    public static class FunctionListBuilder {
        private final List<FunctionInfo> functions = new ArrayList<FunctionInfo>();
        private final Multimap<OperatorType, FunctionInfo> operators = ArrayListMultimap.create();
        private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
        private static final Set<Class<?>> SUPPORTED_RETURN_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE, Integer.TYPE);

        public FunctionListBuilder window(String name, Type returnType, List<? extends Type> argumentTypes, Class<? extends WindowFunction> functionClass) {
            ReflectionWindowFunctionSupplier<? extends WindowFunction> windowFunctionSupplier = new ReflectionWindowFunctionSupplier<WindowFunction>(new Signature(name, returnType, (List<? extends Type>)ImmutableList.copyOf(argumentTypes), false), functionClass);
            this.functions.add(new FunctionInfo(windowFunctionSupplier.getSignature(), windowFunctionSupplier.getDescription(), windowFunctionSupplier));
            return this;
        }

        public FunctionListBuilder approximateAggregate(String name, Type returnType, List<? extends Type> argumentTypes, Type intermediateType, AggregationFunction function) {
            return this.aggregate(name, returnType, argumentTypes, true, intermediateType, function);
        }

        public FunctionListBuilder aggregate(String name, Type returnType, List<? extends Type> argumentTypes, Type intermediateType, AggregationFunction function) {
            return this.aggregate(name, returnType, argumentTypes, false, intermediateType, function);
        }

        private FunctionListBuilder aggregate(String name, Type returnType, List<? extends Type> argumentTypes, boolean approximate, Type intermediateType, AggregationFunction function) {
            name = name.toLowerCase();
            String description = FunctionListBuilder.getDescription(function.getClass());
            this.functions.add(new FunctionInfo(new Signature(name, returnType, (List<? extends Type>)ImmutableList.copyOf(argumentTypes), approximate), description, intermediateType, function));
            return this;
        }

        public FunctionListBuilder scalar(Signature signature, MethodHandle function, boolean deterministic, FunctionBinder functionBinder, String description, boolean hidden) {
            this.functions.add(new FunctionInfo(signature, description, hidden, function, deterministic, functionBinder));
            return this;
        }

        private FunctionListBuilder operator(OperatorType operatorType, Type returnType, List<Type> parameterTypes, MethodHandle function, FunctionBinder functionBinder) {
            this.operators.put((Object)operatorType, (Object)FunctionRegistry.operatorInfo(operatorType, returnType, parameterTypes, function, functionBinder));
            return this;
        }

        public FunctionListBuilder scalar(Class<?> clazz) {
            try {
                boolean foundOne = false;
                for (Method method : clazz.getMethods()) {
                    foundOne = this.processScalarFunction(method) || foundOne;
                    foundOne = this.processScalarOperator(method) || foundOne;
                }
                Preconditions.checkArgument((boolean)foundOne, (String)"Expected class %s to contain at least one method annotated with @%s", (Object[])new Object[]{clazz.getName(), ScalarFunction.class.getSimpleName()});
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this;
        }

        private boolean processScalarFunction(Method method) throws IllegalAccessException {
            SqlType returnTypeAnnotation;
            ScalarFunction scalarFunction = method.getAnnotation(ScalarFunction.class);
            if (scalarFunction == null) {
                return false;
            }
            FunctionListBuilder.checkValidMethod(method);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            String name = scalarFunction.value();
            if (name.isEmpty()) {
                name = FunctionListBuilder.camelToSnake(method.getName());
            }
            Preconditions.checkArgument(((returnTypeAnnotation = method.getAnnotation(SqlType.class)) != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
            Type returnType = FunctionRegistry.type(returnTypeAnnotation);
            Signature signature = new Signature(name.toLowerCase(), returnType, FunctionRegistry.parameterTypes(method), false);
            FunctionRegistry.verifyMethodSignature(method, signature.getReturnType(), signature.getArgumentTypes());
            FunctionBinder functionBinder = this.createFunctionBinder(method, scalarFunction.functionBinder());
            this.scalar(signature, methodHandle, scalarFunction.deterministic(), functionBinder, FunctionListBuilder.getDescription(method), scalarFunction.hidden());
            for (String alias : scalarFunction.alias()) {
                this.scalar(signature.withAlias(alias.toLowerCase()), methodHandle, scalarFunction.deterministic(), functionBinder, FunctionListBuilder.getDescription(method), scalarFunction.hidden());
            }
            return true;
        }

        private boolean processScalarOperator(Method method) throws IllegalAccessException {
            BigintType returnType;
            ScalarOperator scalarOperator = method.getAnnotation(ScalarOperator.class);
            if (scalarOperator == null) {
                return false;
            }
            FunctionListBuilder.checkValidMethod(method);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            OperatorType operatorType = scalarOperator.value();
            List parameterTypes = FunctionRegistry.parameterTypes(method);
            if (operatorType == OperatorType.HASH_CODE) {
                returnType = BigintType.BIGINT;
            } else {
                SqlType explicitType = method.getAnnotation(SqlType.class);
                Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
                returnType = FunctionRegistry.type(explicitType);
                FunctionRegistry.verifyMethodSignature(method, (Type)returnType, parameterTypes);
            }
            FunctionBinder functionBinder = this.createFunctionBinder(method, scalarOperator.functionBinder());
            this.operator(operatorType, (Type)returnType, parameterTypes, methodHandle, functionBinder);
            return true;
        }

        private FunctionBinder createFunctionBinder(Method method, Class<? extends FunctionBinder> functionBinderClass) {
            try {
                Constructor<? extends FunctionBinder> constructor = functionBinderClass.getConstructor(MethodHandle.class, Boolean.TYPE);
                return constructor.newInstance(MethodHandles.lookup().unreflect(method), method.isAnnotationPresent(Nullable.class));
            }
            catch (ReflectiveOperationException | RuntimeException ignored) {
                try {
                    return functionBinderClass.newInstance();
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Unable to create function binder " + functionBinderClass.getName() + " for function " + method);
                }
            }
        }

        private static String getDescription(AnnotatedElement annotatedElement) {
            Description description = annotatedElement.getAnnotation(Description.class);
            return description == null ? null : description.value();
        }

        private static String camelToSnake(String name) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        }

        private static void checkValidMethod(Method method) {
            String message = "@ScalarFunction method %s is not valid: ";
            Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)(message + "must be static"), (Object[])new Object[]{method});
            Preconditions.checkArgument((boolean)SUPPORTED_RETURN_TYPES.contains(Primitives.unwrap(method.getReturnType())), (String)(message + "return type not supported"), (Object[])new Object[]{method});
            if (method.getAnnotation(Nullable.class) != null) {
                Preconditions.checkArgument((!method.getReturnType().isPrimitive() ? 1 : 0) != 0, (String)(message + "annotated with @Nullable but has primitive return type"), (Object[])new Object[]{method});
            } else {
                Preconditions.checkArgument((!Primitives.isWrapperType(method.getReturnType()) ? 1 : 0) != 0, (String)"not annotated with @Nullable but has boxed primitive return type", (Object[])new Object[]{method});
            }
            for (Class type : FunctionRegistry.getParameterTypes(method.getParameterTypes())) {
                Preconditions.checkArgument((boolean)SUPPORTED_TYPES.contains(type), (String)(message + "parameter type [%s] not supported"), (Object[])new Object[]{method, type.getName()});
            }
        }

        public List<FunctionInfo> getFunctions() {
            return ImmutableList.copyOf(this.functions);
        }

        public Multimap<OperatorType, FunctionInfo> getOperators() {
            return ImmutableMultimap.copyOf(this.operators);
        }
    }
}

