/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class FunctionInfo {
    private final Signature signature;
    private final String description;
    private final boolean hidden;
    private final boolean isAggregate;
    private final Type intermediateType;
    private final AggregationFunction aggregationFunction;
    private final MethodHandle methodHandle;
    private final boolean deterministic;
    private final FunctionBinder functionBinder;
    private final boolean isWindow;
    private final WindowFunctionSupplier windowFunctionSupplier;

    public FunctionInfo(Signature signature, String description, WindowFunctionSupplier windowFunctionSupplier) {
        this.signature = signature;
        this.description = description;
        this.hidden = false;
        this.deterministic = true;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.methodHandle = null;
        this.functionBinder = null;
        this.isWindow = true;
        this.windowFunctionSupplier = (WindowFunctionSupplier)Preconditions.checkNotNull((Object)windowFunctionSupplier, (Object)"windowFunction is null");
    }

    public FunctionInfo(Signature signature, String description, Type intermediateType, AggregationFunction function) {
        this.signature = signature;
        this.description = description;
        this.hidden = false;
        this.intermediateType = intermediateType;
        this.aggregationFunction = function;
        this.isAggregate = true;
        this.methodHandle = null;
        this.deterministic = true;
        this.functionBinder = null;
        this.isWindow = false;
        this.windowFunctionSupplier = null;
    }

    public FunctionInfo(Signature signature, String description, boolean hidden, MethodHandle function, boolean deterministic, FunctionBinder functionBinder) {
        this.signature = signature;
        this.description = description;
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.functionBinder = functionBinder;
        this.isAggregate = false;
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.isWindow = false;
        this.windowFunctionSupplier = null;
        this.methodHandle = (MethodHandle)Preconditions.checkNotNull((Object)function, (Object)"function is null");
    }

    public Signature getSignature() {
        return this.signature;
    }

    public QualifiedName getName() {
        return QualifiedName.of((String)this.signature.getName(), (String[])new String[0]);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isWindow() {
        return this.isWindow;
    }

    public boolean isScalar() {
        return !this.isWindow && !this.isAggregate;
    }

    public boolean isApproximate() {
        return this.signature.isApproximate();
    }

    public Type getReturnType() {
        return this.signature.getReturnType();
    }

    public List<Type> getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public WindowFunctionDefinition bindWindowFunction(List<Input> inputs) {
        Preconditions.checkState((boolean)this.isWindow, (Object)"not a window function");
        return WindowFunctionDefinition.window(this.windowFunctionSupplier, inputs);
    }

    public AggregationFunctionDefinition bind(List<Input> inputs, Optional<Input> mask, Optional<Input> sampleWeight, double confidence) {
        Preconditions.checkState((boolean)this.isAggregate, (Object)"function is not an aggregate");
        return AggregationFunctionDefinition.aggregation(this.aggregationFunction, inputs, mask, sampleWeight, confidence);
    }

    public AggregationFunction getAggregationFunction() {
        Preconditions.checkState((this.aggregationFunction != null ? 1 : 0) != 0, (Object)"not an aggregation function");
        return this.aggregationFunction;
    }

    public MethodHandle getMethodHandle() {
        Preconditions.checkState((this.methodHandle != null ? 1 : 0) != 0, (Object)"not a scalar function or operator");
        return this.methodHandle;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public FunctionBinder getFunctionBinder() {
        return this.functionBinder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionInfo other = (FunctionInfo)obj;
        return Objects.equal((Object)this.signature, (Object)other.signature) && Objects.equal((Object)this.isAggregate, (Object)other.isAggregate) && Objects.equal((Object)this.isWindow, (Object)other.isWindow);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.signature, this.isAggregate, this.isWindow});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("signature", (Object)this.signature).add("isAggregate", this.isAggregate).add("isWindow", this.isWindow).toString();
    }

    public static Function<FunctionInfo, QualifiedName> nameGetter() {
        return new Function<FunctionInfo, QualifiedName>(){

            public QualifiedName apply(FunctionInfo input) {
                return input.getName();
            }
        };
    }

    public static Function<FunctionInfo, Signature> handleGetter() {
        return new Function<FunctionInfo, Signature>(){

            public Signature apply(FunctionInfo input) {
                return input.getSignature();
            }
        };
    }

    public static Predicate<FunctionInfo> isAggregationPredicate() {
        return new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo functionInfo) {
                return functionInfo.isAggregate();
            }
        };
    }

    public static Predicate<FunctionInfo> isHiddenPredicate() {
        return new Predicate<FunctionInfo>(){

            public boolean apply(FunctionInfo functionInfo) {
                return functionInfo.isHidden();
            }
        };
    }
}

