/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.AbandonedException;
import com.facebook.presto.execution.FailedQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.IterableTransformer;
import com.facebook.presto.util.SetThreadName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final int maxQueryHistory;
    private final Duration maxQueryAge;
    private final ConcurrentMap<QueryId, QueryExecution> queries = new ConcurrentHashMap<QueryId, QueryExecution>();
    private final Duration clientTimeout;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final QueryIdGenerator queryIdGenerator;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final SqlQueryManagerStats stats = new SqlQueryManagerStats();

    @Inject
    public SqlQueryManager(QueryManagerConfig config, QueryMonitor queryMonitor, QueryIdGenerator queryIdGenerator, LocationFactory locationFactory, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories) {
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.executionFactories = (Map)Preconditions.checkNotNull(executionFactories, (Object)"executionFactories is null");
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%d"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
        this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        this.queryIdGenerator = (QueryIdGenerator)Preconditions.checkNotNull((Object)queryIdGenerator, (Object)"queryIdGenerator is null");
        this.maxQueryAge = config.getMaxQueryAge();
        this.maxQueryHistory = config.getMaxQueryHistory();
        this.clientTimeout = config.getClientTimeout();
        this.queryManagementExecutor = Executors.newScheduledThreadPool(config.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%d"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryManagementExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlQueryManager.this.removeExpiredQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error removing old queries");
                }
                try {
                    SqlQueryManager.this.failAbandonedQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error removing old queries");
                }
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<QueryInfo> getAllQueryInfo() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(this.queries.values(), (Function)new Function<QueryExecution, QueryInfo>(){

            public QueryInfo apply(QueryExecution queryExecution) {
                try {
                    return queryExecution.getQueryInfo();
                }
                catch (RuntimeException ignored) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public Duration waitForStateChange(QueryId queryId, QueryState currentState, Duration maxWait) throws InterruptedException {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            return maxWait;
        }
        query.recordHeartbeat();
        return query.waitForStateChange(currentState, maxWait);
    }

    @Override
    public QueryInfo getQueryInfo(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            throw new NoSuchElementException();
        }
        query.recordHeartbeat();
        return query.getQueryInfo();
    }

    @Override
    public QueryInfo createQuery(ConnectorSession session, String query) {
        Statement statement;
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        try {
            statement = SqlParser.createStatement((String)query);
        }
        catch (ParsingException e) {
            return this.createFailedQuery(session, query, queryId, e);
        }
        QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(statement.getClass());
        Preconditions.checkState((queryExecutionFactory != null ? 1 : 0) != 0, (String)"Unsupported statement type %s", (Object[])new Object[]{statement.getClass().getName()});
        final Object queryExecution = queryExecutionFactory.createQueryExecution(queryId, query, session, statement);
        this.queryMonitor.createdEvent(queryExecution.getQueryInfo());
        queryExecution.addStateChangeListener(new StateMachine.StateChangeListener<QueryState>(){

            @Override
            public void stateChanged(QueryState newValue) {
                if (newValue.isDone()) {
                    QueryInfo info = queryExecution.getQueryInfo();
                    SqlQueryManager.this.stats.queryFinished(info);
                    SqlQueryManager.this.queryMonitor.completionEvent(info);
                }
            }
        });
        this.queries.put(queryId, (QueryExecution)queryExecution);
        this.queryExecutor.submit(new QueryStarter((QueryExecution)queryExecution, this.stats));
        return queryExecution.getQueryInfo();
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        log.debug("Cancel query %s", new Object[]{queryId});
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query != null) {
            query.cancel();
        }
    }

    @Override
    public void cancelStage(StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        QueryExecution query = (QueryExecution)this.queries.get(stageId.getQueryId());
        if (query != null) {
            query.cancelStage(stageId);
        }
    }

    @Managed
    @Flatten
    public SqlQueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    public void removeQuery(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        log.debug("Remove query %s", new Object[]{queryId});
        QueryExecution query = (QueryExecution)this.queries.remove(queryId);
        if (query != null) {
            query.cancel();
        }
    }

    public void removeExpiredQueries() {
        List sortedQueries = IterableTransformer.on(this.queries.values()).select(Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.isNull()), SqlQueryManager.endTimeGetter())).orderBy(Ordering.natural().onResultOf(SqlQueryManager.endTimeGetter())).list();
        int toRemove = Math.max(sortedQueries.size() - this.maxQueryHistory, 0);
        DateTime oldestAllowedQuery = DateTime.now().minus(this.maxQueryAge.toMillis());
        for (QueryExecution queryExecution : sortedQueries) {
            try {
                DateTime endTime = queryExecution.getQueryInfo().getQueryStats().getEndTime();
                if (!endTime.isBefore((ReadableInstant)oldestAllowedQuery) && toRemove <= 0 || !this.isAbandoned(queryExecution)) continue;
                this.removeQuery(queryExecution.getQueryInfo().getQueryId());
                --toRemove;
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of query %s", new Object[]{queryExecution.getQueryInfo().getQueryId()});
            }
        }
    }

    public void failAbandonedQueries() {
        for (QueryExecution queryExecution : this.queries.values()) {
            try {
                QueryInfo queryInfo = queryExecution.getQueryInfo();
                if (queryInfo.getState().isDone() || !this.isAbandoned(queryExecution)) continue;
                log.info("Failing abandoned query %s", new Object[]{queryExecution.getQueryInfo().getQueryId()});
                queryExecution.fail((Throwable)((Object)new AbandonedException("Query " + queryInfo.getQueryId(), queryInfo.getQueryStats().getLastHeartbeat(), DateTime.now())));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of query %s", new Object[]{queryExecution.getQueryInfo().getQueryId()});
            }
        }
    }

    private boolean isAbandoned(QueryExecution query) {
        DateTime oldestAllowedHeartbeat = DateTime.now().minus(this.clientTimeout.toMillis());
        DateTime lastHeartbeat = query.getQueryInfo().getQueryStats().getLastHeartbeat();
        return lastHeartbeat != null && lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat);
    }

    private QueryInfo createFailedQuery(ConnectorSession session, String query, QueryId queryId, Throwable cause) {
        URI self = this.locationFactory.createQueryLocation(queryId);
        FailedQueryExecution execution = new FailedQueryExecution(queryId, query, session, self, this.queryExecutor, cause);
        this.queries.put(queryId, execution);
        this.stats.queryStarted();
        this.queryMonitor.createdEvent(execution.getQueryInfo());
        this.queryMonitor.completionEvent(execution.getQueryInfo());
        this.stats.queryFinished(execution.getQueryInfo());
        return execution.getQueryInfo();
    }

    private static Function<QueryExecution, DateTime> endTimeGetter() {
        return new Function<QueryExecution, DateTime>(){

            @Nullable
            public DateTime apply(QueryExecution input) {
                return input.getQueryInfo().getQueryStats().getEndTime();
            }
        };
    }

    private static class QueryStarter
    implements Runnable {
        private final QueryExecution queryExecution;
        private final SqlQueryManagerStats stats;

        public QueryStarter(QueryExecution queryExecution, SqlQueryManagerStats stats) {
            this.queryExecution = queryExecution;
            this.stats = stats;
        }

        @Override
        public void run() {
            try (SetThreadName setThreadName = new SetThreadName("Query-%s", this.queryExecution.getQueryInfo().getQueryId());){
                this.stats.queryStarted();
                this.queryExecution.start();
            }
        }
    }
}

