/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    private final DataDefinitionTask<T> task;
    private final T statement;
    private final ConnectorSession session;
    private final Metadata metadata;
    private final QueryStateMachine stateMachine;

    private DataDefinitionExecution(DataDefinitionTask<T> task, T statement, ConnectorSession session, Metadata metadata, QueryStateMachine stateMachine) {
        this.task = (DataDefinitionTask)Preconditions.checkNotNull(task, (Object)"task is null");
        this.statement = (Statement)Preconditions.checkNotNull(statement, (Object)"statement is null");
        this.session = (ConnectorSession)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.stateMachine = (QueryStateMachine)Preconditions.checkNotNull((Object)stateMachine, (Object)"stateMachine is null");
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.starting()) {
                return;
            }
            this.stateMachine.recordExecutionStart();
            this.task.execute(this.statement, this.session, this.metadata);
            this.stateMachine.finished();
        }
        catch (RuntimeException e) {
            this.fail(e);
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.stateMachine.waitForStateChange(currentState, maxWait);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void cancel() {
        this.stateMachine.cancel();
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.fail(cause);
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getQueryInfoWithoutDetails();
    }

    /* synthetic */ DataDefinitionExecution(DataDefinitionTask x0, Statement x1, ConnectorSession x2, Metadata x3, QueryStateMachine x4, 1 x5) {
        this(x0, x1, x2, x3, x4);
    }

    static class 1 {
    }

    public static class DataDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DataDefinitionExecution<?>> {
        private final LocationFactory locationFactory;
        private final Metadata metadata;
        private final ExecutorService executor;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DataDefinitionExecutionFactory(LocationFactory locationFactory, MetadataManager metadata, @ForQueryExecution ExecutorService executor, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
            this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
            this.tasks = (Map)Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        }

        @Override
        public DataDefinitionExecution<?> createQueryExecution(QueryId queryId, String query, ConnectorSession session, Statement statement) {
            URI self = this.locationFactory.createQueryLocation(queryId);
            QueryStateMachine stateMachine = new QueryStateMachine(queryId, query, session, self, this.executor);
            return this.createExecution(statement, session, stateMachine);
        }

        private <T extends Statement> DataDefinitionExecution<?> createExecution(T statement, ConnectorSession session, QueryStateMachine stateMachine) {
            DataDefinitionTask<T> task = this.getTask(statement);
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)("no task for statement: " + statement.getClass()));
            return new DataDefinitionExecution(task, statement, session, this.metadata, stateMachine, null);
        }

        private <T extends Statement> DataDefinitionTask<T> getTask(T statement) {
            return this.tasks.get(statement.getClass());
        }
    }
}

