/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SystemSplitManager
implements ConnectorSplitManager {
    public static final String SYSTEM_DATASOURCE = "system";
    private final NodeManager nodeManager;
    private final ConcurrentMap<SchemaTableName, SystemTable> tables = new ConcurrentHashMap<SchemaTableName, SystemTable>();

    @Inject
    public SystemSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public void addTable(SystemTable systemTable) {
        Preconditions.checkNotNull((Object)systemTable, (Object)"systemTable is null");
        SchemaTableName tableName = systemTable.getTableMetadata().getTable();
        Preconditions.checkArgument((this.tables.putIfAbsent(tableName, systemTable) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableName});
    }

    public String getConnectorId() {
        return null;
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle table, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
        Preconditions.checkArgument((boolean)(table instanceof SystemTableHandle), (Object)"TableHandle must be an SystemTableHandle");
        SystemTableHandle systemTableHandle = (SystemTableHandle)table;
        ImmutableList partitions = ImmutableList.of((Object)new SystemPartition(systemTableHandle));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle table, List<ConnectorPartition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(SYSTEM_DATASOURCE, (Iterable)ImmutableList.of());
        }
        ConnectorPartition partition = (ConnectorPartition)Iterables.getOnlyElement(partitions);
        Preconditions.checkArgument((boolean)(partition instanceof SystemPartition), (Object)"Partition must be a system partition");
        SystemPartition systemPartition = (SystemPartition)partition;
        SystemTable systemTable = (SystemTable)this.tables.get(systemPartition.getTableHandle().getSchemaTableName());
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{systemPartition.getTableHandle().getTableName()});
        if (systemTable.isDistributed()) {
            ImmutableList.Builder splits = ImmutableList.builder();
            for (Node node : this.nodeManager.getActiveNodes()) {
                splits.add((Object)new SystemSplit(systemPartition.tableHandle, node.getHostAndPort()));
            }
            return new FixedSplitSource(SYSTEM_DATASOURCE, (Iterable)splits.build());
        }
        HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
        SystemSplit split = new SystemSplit(systemPartition.tableHandle, address);
        return new FixedSplitSource(SYSTEM_DATASOURCE, (Iterable)ImmutableList.of((Object)split));
    }

    public static class SystemPartition
    implements ConnectorPartition {
        private final SystemTableHandle tableHandle;

        public SystemPartition(SystemTableHandle tableHandle) {
            this.tableHandle = (SystemTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        }

        public SystemTableHandle getTableHandle() {
            return this.tableHandle;
        }

        public String getPartitionId() {
            return this.tableHandle.getSchemaTableName().toString();
        }

        public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
            return TupleDomain.all();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).toString();
        }
    }
}

