/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.MappedRecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SystemDataStreamProvider
implements ConnectorDataStreamProvider {
    private final ConcurrentMap<SchemaTableName, SystemTable> tables = new ConcurrentHashMap<SchemaTableName, SystemTable>();

    public void addTable(SystemTable systemTable) {
        Preconditions.checkNotNull((Object)systemTable, (Object)"systemTable is null");
        SchemaTableName tableName = systemTable.getTableMetadata().getTable();
        Preconditions.checkArgument((this.tables.putIfAbsent(tableName, systemTable) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableName});
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, ConnectorSplit split, List<ConnectorColumnHandle> columns) {
        return new RecordProjectOperator(operatorContext, this.createRecordSet(split, columns));
    }

    private RecordSet createRecordSet(ConnectorSplit split, List<ConnectorColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof SystemSplit), (String)"Split must be of type %s, not %s", (Object[])new Object[]{SystemSplit.class.getName(), split.getClass().getName()});
        SchemaTableName tableName = ((SystemSplit)split).getTableHandle().getSchemaTableName();
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        SystemTable systemTable = (SystemTable)this.tables.get(tableName);
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableMap columnsByName = Maps.uniqueIndex((Iterable)systemTable.getTableMetadata().getColumns(), MetadataUtil.columnNameGetter());
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ConnectorColumnHandle column : columns) {
            Preconditions.checkArgument((boolean)(column instanceof SystemColumnHandle), (String)"column must be of type %s, not %s", (Object[])new Object[]{SystemColumnHandle.class.getName(), column.getClass().getName()});
            String columnName = ((SystemColumnHandle)column).getColumnName();
            ColumnMetadata columnMetadata = (ColumnMetadata)columnsByName.get(columnName);
            Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s.%s does not exist", (Object[])new Object[]{tableName, columnName});
            userToSystemFieldIndex.add((Object)columnMetadata.getOrdinalPosition());
        }
        return new MappedRecordSet((RecordSet)systemTable, (List<Integer>)userToSystemFieldIndex.build());
    }
}

