/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxMetadata
extends ReadOnlyConnectorMetadata {
    public static final String SCHEMA_NAME = "jmx";
    private final String connectorId;
    private final MBeanServer mbeanServer;

    @Inject
    public JmxMetadata(JmxConnectorId jmxConnectorId, MBeanServer mbeanServer) {
        this.connectorId = ((JmxConnectorId)Preconditions.checkNotNull((Object)jmxConnectorId, (Object)"jmxConnectorId is null")).toString();
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer, (Object)"mbeanServer is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public JmxTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!tableName.getSchemaName().equals(SCHEMA_NAME)) {
            return null;
        }
        try {
            ObjectName objectName = (ObjectName)Iterables.find(this.mbeanServer.queryNames(ObjectName.WILDCARD, null), this.objectNameEqualsIgnoreCase(new ObjectName(tableName.getTableName())));
            MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
            ImmutableList.Builder columns = ImmutableList.builder();
            int ordinalPosition = 0;
            columns.add((Object)new JmxColumnHandle(this.connectorId, "node", (Type)VarcharType.VARCHAR, ordinalPosition++));
            for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
                if (!attribute.isReadable()) continue;
                columns.add((Object)new JmxColumnHandle(this.connectorId, attribute.getName(), this.getColumnType(attribute), ordinalPosition++));
            }
            return new JmxTableHandle(this.connectorId, objectName.toString(), (List<JmxColumnHandle>)columns.build());
        }
        catch (NoSuchElementException | JMException e) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof JmxTableHandle), (Object)"tableHandle is not an instance of JmxTableHandle");
        JmxTableHandle jmxTableHandle = (JmxTableHandle)tableHandle;
        return jmxTableHandle.getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull != null && !schemaNameOrNull.equals(SCHEMA_NAME)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            tableNames.add((Object)new SchemaTableName(SCHEMA_NAME, objectName.toString().toLowerCase()));
        }
        return tableNames.build();
    }

    public ConnectorColumnHandle getColumnHandle(ConnectorTableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof JmxTableHandle), (Object)"tableHandle is not an instance of JmxTableHandle");
        JmxTableHandle jmxTableHandle = (JmxTableHandle)tableHandle;
        for (JmxColumnHandle jmxColumnHandle : jmxTableHandle.getColumns()) {
            if (!jmxColumnHandle.getColumnName().equalsIgnoreCase(columnName)) continue;
            return jmxColumnHandle;
        }
        return null;
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof JmxTableHandle), (Object)"tableHandle is not an instance of JmxTableHandle");
        JmxTableHandle jmxTableHandle = (JmxTableHandle)tableHandle;
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(jmxTableHandle.getColumns(), (Function)new Function<JmxColumnHandle, String>(){

            public String apply(JmxColumnHandle input) {
                return input.getColumnName().toLowerCase();
            }
        }));
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof JmxTableHandle), (Object)"tableHandle is not an instance of JmxTableHandle");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof JmxColumnHandle), (Object)"columnHandle is not an instance of JmxColumnHandle");
        JmxColumnHandle jmxColumnHandle = (JmxColumnHandle)columnHandle;
        return jmxColumnHandle.getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        if (prefix.getSchemaName() != null && !prefix.getSchemaName().equals(SCHEMA_NAME)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            JmxTableHandle tableHandle = this.getTableHandle(session, tableName);
            columns.put((Object)tableName, (Object)tableHandle.getTableMetadata().getColumns());
        }
        return columns.build();
    }

    private Type getColumnType(MBeanAttributeInfo attribute) {
        BooleanType columnType;
        switch (attribute.getType()) {
            case "boolean": 
            case "java.lang.Boolean": {
                columnType = BooleanType.BOOLEAN;
                break;
            }
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                columnType = BigintType.BIGINT;
                break;
            }
            case "java.lang.Number": 
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                columnType = DoubleType.DOUBLE;
                break;
            }
            default: {
                columnType = VarcharType.VARCHAR;
            }
        }
        return columnType;
    }

    private Predicate<ObjectName> objectNameEqualsIgnoreCase(ObjectName objectName) {
        final String canonicalObjectName = objectName.getCanonicalName();
        return new Predicate<ObjectName>(){

            public boolean apply(ObjectName input) {
                return canonicalObjectName.equalsIgnoreCase(input.getCanonicalName());
            }
        };
    }
}

