/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DynamicClassLoader
extends ClassLoader {
    private final ConcurrentMap<String, byte[]> pendingClasses = new ConcurrentHashMap<String, byte[]>();

    public DynamicClassLoader() {
        this(null);
    }

    public DynamicClassLoader(ClassLoader parentClassLoader) {
        super(DynamicClassLoader.resolveClassLoader(parentClassLoader));
    }

    public Class<?> defineClass(String className, byte[] byteCode) {
        return super.defineClass(className, byteCode, 0, byteCode.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> defineClasses(Map<String, byte[]> newClasses) {
        Sets.SetView conflicts = Sets.intersection(this.pendingClasses.keySet(), newClasses.keySet());
        Preconditions.checkArgument((boolean)conflicts.isEmpty(), (String)"The classes %s have already been defined", (Object[])new Object[]{conflicts});
        this.pendingClasses.putAll(newClasses);
        try {
            HashMap classes = new HashMap();
            for (String className : newClasses.keySet()) {
                try {
                    Class<?> clazz = this.loadClass(className);
                    classes.put(className, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            HashMap hashMap = classes;
            return hashMap;
        }
        finally {
            this.pendingClasses.keySet().removeAll(newClasses.keySet());
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] byteCode = (byte[])this.pendingClasses.get(name);
        if (byteCode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, byteCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            try {
                Class<?> clazz = this.findClass(name);
                return this.resolveClass(clazz, resolve);
            }
            catch (ClassNotFoundException ignored) {
                Class<?> clazz = this.getParent().loadClass(name);
                return this.resolveClass(clazz, resolve);
            }
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private static ClassLoader resolveClassLoader(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (parentClassLoader == null) {
            parentClassLoader = DynamicClassLoader.class.getClassLoader();
        }
        if (parentClassLoader == null) {
            parentClassLoader = ClassLoader.getSystemClassLoader();
        }
        return parentClassLoader;
    }
}

