/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.snappy;

import com.facebook.presto.block.snappy.SnappyBlock;
import com.facebook.presto.serde.TypeSerde;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class SnappyBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<SnappyBlockEncoding> FACTORY = new SnappyBlockEncodingFactory();
    private static final String NAME = "SNAPPY";
    private final Type type;
    private final BlockEncoding uncompressedBlockEncoding;

    public SnappyBlockEncoding(Type type, BlockEncoding uncompressedBlockEncoding) {
        this.type = type;
        this.uncompressedBlockEncoding = uncompressedBlockEncoding;
    }

    public String getName() {
        return NAME;
    }

    public Type getType() {
        return this.type;
    }

    public void writeBlock(SliceOutput sliceOutput, Block block) {
        SnappyBlock snappyBlock = (SnappyBlock)block;
        Preconditions.checkArgument((boolean)block.getType().equals(this.type), (Object)"Invalid block");
        Slice compressedSlice = snappyBlock.getCompressedSlice();
        sliceOutput.appendInt(compressedSlice.length()).appendInt(snappyBlock.getPositionCount()).writeBytes(compressedSlice);
    }

    public Block readBlock(SliceInput sliceInput) {
        int blockSize = sliceInput.readInt();
        int positionCount = sliceInput.readInt();
        Slice compressedSlice = sliceInput.readSlice(blockSize);
        return new SnappyBlock(positionCount, this.type, compressedSlice, this.uncompressedBlockEncoding);
    }

    private static class SnappyBlockEncodingFactory
    implements BlockEncodingFactory<SnappyBlockEncoding> {
        private SnappyBlockEncodingFactory() {
        }

        public String getName() {
            return SnappyBlockEncoding.NAME;
        }

        public SnappyBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            Type type = TypeSerde.readType(manager, input);
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new SnappyBlockEncoding(type, valueBlockEncoding);
        }

        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, SnappyBlockEncoding blockEncoding) {
            TypeSerde.writeInfo(output, blockEncoding.type);
            serde.writeBlockEncoding(output, blockEncoding.uncompressedBlockEncoding);
        }
    }
}

