/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.snappy;

import com.facebook.presto.block.snappy.SnappyBlockEncoding;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.iq80.snappy.Snappy;

public class SnappyBlock
implements Block {
    private static final DataSize ENCODING_BUFFER_OVERHEAD = new DataSize(1.0, DataSize.Unit.KILOBYTE);
    private final int positionCount;
    private final Type type;
    private final Slice compressedSlice;
    private final BlockEncoding uncompressedBlockEncoding;
    @GuardedBy(value="this")
    private Block uncompressedBlock;

    public SnappyBlock(int positionCount, Type type, Slice compressedSlice, BlockEncoding uncompressedBlockEncoding) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = positionCount;
        this.compressedSlice = (Slice)Preconditions.checkNotNull((Object)compressedSlice, (Object)"compressedSlice is null");
        this.uncompressedBlockEncoding = (BlockEncoding)Preconditions.checkNotNull((Object)uncompressedBlockEncoding, (Object)"uncompressedBlockEncoding is null");
    }

    public SnappyBlock(Block block) {
        this.type = block.getType();
        this.positionCount = block.getPositionCount();
        this.uncompressedBlock = block;
        this.uncompressedBlockEncoding = block.getEncoding();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(Ints.checkedCast((long)((long)this.uncompressedBlock.getSizeInBytes() + ENCODING_BUFFER_OVERHEAD.toBytes())));
        this.uncompressedBlockEncoding.writeBlock((SliceOutput)sliceOutput, this.uncompressedBlock);
        Slice uncompressedSlice = sliceOutput.slice();
        byte[] compressedBytes = new byte[Snappy.maxCompressedLength((int)uncompressedSlice.length())];
        int actualLength = Snappy.compress((byte[])uncompressedSlice.getBytes(), (int)0, (int)uncompressedSlice.length(), (byte[])compressedBytes, (int)0);
        this.compressedSlice = Slices.wrappedBuffer((byte[])Arrays.copyOf(compressedBytes, actualLength));
    }

    public Type getType() {
        return this.type;
    }

    public Slice getCompressedSlice() {
        return this.compressedSlice;
    }

    public synchronized Block getUncompressedBlock() {
        if (this.uncompressedBlock == null) {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])this.compressedSlice.getBytes(), (int)0);
            Preconditions.checkState((uncompressedLength > 0 ? 1 : 0) != 0, (Object)"Empty block encountered!");
            byte[] output = new byte[uncompressedLength];
            Snappy.uncompress((byte[])this.compressedSlice.getBytes(), (int)0, (int)this.compressedSlice.length(), (byte[])output, (int)0);
            this.uncompressedBlock = this.uncompressedBlockEncoding.readBlock((SliceInput)Slices.wrappedBuffer((byte[])output).getInput());
        }
        return this.uncompressedBlock;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getSizeInBytes() {
        return this.getUncompressedBlock().getSizeInBytes();
    }

    public BlockCursor cursor() {
        return this.getUncompressedBlock().cursor();
    }

    public SnappyBlockEncoding getEncoding() {
        return new SnappyBlockEncoding(this.type, this.uncompressedBlockEncoding);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.getUncompressedBlock().getRegion(positionOffset, length);
    }

    public boolean getBoolean(int position) {
        return this.getUncompressedBlock().getBoolean(position);
    }

    public long getLong(int position) {
        return this.getUncompressedBlock().getLong(position);
    }

    public double getDouble(int position) {
        return this.getUncompressedBlock().getDouble(position);
    }

    public Slice getSlice(int position) {
        return this.getUncompressedBlock().getSlice(position);
    }

    public Object getObjectValue(ConnectorSession session, int position) {
        return this.getUncompressedBlock().getObjectValue(session, position);
    }

    public Block getSingleValueBlock(int position) {
        return this.getUncompressedBlock().getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.getUncompressedBlock().isNull(position);
    }

    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        return this.getUncompressedBlock().equalTo(position, otherBlock, otherPosition);
    }

    public boolean equalTo(int position, BlockCursor cursor) {
        return this.getUncompressedBlock().equalTo(position, cursor);
    }

    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        return this.getUncompressedBlock().equalTo(position, otherSlice, otherOffset);
    }

    public int hash(int position) {
        return this.getUncompressedBlock().hash(position);
    }

    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        return this.getUncompressedBlock().compareTo(sortOrder, position, otherBlock, otherPosition);
    }

    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        return this.getUncompressedBlock().compareTo(sortOrder, position, cursor);
    }

    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        return this.getUncompressedBlock().compareTo(position, otherSlice, otherOffset);
    }

    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.getUncompressedBlock().appendTo(position, blockBuilder);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("type", (Object)this.type).add("compressedSlice", (Object)this.compressedSlice).toString();
    }
}

