/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;

public class SqlUtils {
    public static void runIgnoringConstraintViolation(Runnable task) {
        try {
            task.run();
        }
        catch (UnableToExecuteStatementException e) {
            String state;
            if (e.getCause() instanceof SQLException && (state = ((SQLException)e.getCause()).getSQLState()).startsWith("23")) {
                return;
            }
            throw e;
        }
    }

    public static <T> T runIgnoringConstraintViolation(Callable<T> task, T defaultValue) throws Exception {
        try {
            return task.call();
        }
        catch (UnableToExecuteStatementException e) {
            String state;
            if (e.getCause() instanceof SQLException && (state = ((SQLException)e.getCause()).getSQLState()).startsWith("23")) {
                return defaultValue;
            }
            throw e;
        }
    }
}

