/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class DelimitedRecordSet
implements RecordSet {
    private final InputSupplier<? extends Reader> readerSupplier;
    private final Splitter columnSplitter;
    private final List<ColumnMetadata> columns;
    private final List<ColumnType> columnTypes;

    public DelimitedRecordSet(InputSupplier<? extends Reader> readerSupplier, Splitter columnSplitter, ColumnMetadata ... columns) {
        this(readerSupplier, columnSplitter, (Iterable<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public DelimitedRecordSet(InputSupplier<? extends Reader> readerSupplier, Splitter columnSplitter, Iterable<ColumnMetadata> columns) {
        Preconditions.checkNotNull(readerSupplier, (Object)"readerSupplier is null");
        Preconditions.checkNotNull((Object)columnSplitter, (Object)"columnSplitter is null");
        this.readerSupplier = readerSupplier;
        this.columnSplitter = columnSplitter;
        this.columns = ImmutableList.copyOf(columns);
        this.columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform(columns, MetadataUtil.columnTypeGetter()));
    }

    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new DelimitedRecordCursor(this.readerSupplier, this.columnSplitter, this.columns);
    }

    private static class DelimitedRecordCursor
    implements RecordCursor {
        private final Reader reader;
        private final LineReader lineReader;
        private final Splitter columnSplitter;
        private final List<ColumnMetadata> columns;
        private List<String> row;

        private DelimitedRecordCursor(InputSupplier<? extends Reader> readerSupplier, Splitter columnSplitter, List<ColumnMetadata> columns) {
            try {
                this.reader = (Reader)readerSupplier.getInput();
                this.lineReader = new LineReader((Readable)this.reader);
                this.columnSplitter = columnSplitter;
                this.columns = columns;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public ColumnType getType(int field) {
            return this.columns.get(field).getType();
        }

        public boolean advanceNextPosition() {
            try {
                String line = this.lineReader.readLine();
                if (line == null) {
                    this.row = null;
                    return false;
                }
                this.row = ImmutableList.copyOf((Iterable)this.columnSplitter.split((CharSequence)line));
                return true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean getBoolean(int field) {
            return Boolean.parseBoolean(this.getField(field));
        }

        public long getLong(int field) {
            return Long.parseLong(this.getField(field));
        }

        public double getDouble(int field) {
            return Double.parseDouble(this.getField(field));
        }

        public byte[] getString(int field) {
            return this.getField(field).getBytes(Charsets.UTF_8);
        }

        public boolean isNull(int field) {
            return this.getField(field).isEmpty();
        }

        private String getField(int field) {
            ColumnMetadata columnMetadata = this.columns.get(field);
            return this.row.get(columnMetadata.getOrdinalPosition());
        }

        public void close() {
            Closeables.closeQuietly((Closeable)this.reader);
        }
    }
}

