/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Tuple
implements TupleReadable {
    private final Slice slice;
    private final TupleInfo tupleInfo;

    public Tuple(Slice slice, TupleInfo tupleInfo) {
        this.slice = slice;
        this.tupleInfo = tupleInfo;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    @Override
    public Tuple getTuple() {
        return this;
    }

    public Slice getTupleSlice() {
        return this.slice;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.tupleInfo.getBoolean(this.slice, index);
    }

    @Override
    public long getLong(int index) {
        return this.tupleInfo.getLong(this.slice, index);
    }

    @Override
    public double getDouble(int index) {
        return this.tupleInfo.getDouble(this.slice, index);
    }

    @Override
    public Slice getSlice(int index) {
        return this.tupleInfo.getSlice(this.slice, index);
    }

    @Override
    public boolean isNull(int index) {
        return this.tupleInfo.isNull(this.slice, index);
    }

    public int size() {
        return this.tupleInfo.size(this.slice);
    }

    public void writeTo(SliceOutput out) {
        out.writeBytes(this.slice);
    }

    public List<Object> toValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        int index = 0;
        for (TupleInfo.Type type : this.tupleInfo.getTypes()) {
            if (this.isNull(index)) {
                values.add(null);
            } else {
                switch (type) {
                    case BOOLEAN: {
                        values.add(this.getBoolean(index));
                        break;
                    }
                    case FIXED_INT_64: {
                        values.add(this.getLong(index));
                        break;
                    }
                    case DOUBLE: {
                        values.add(this.getDouble(index));
                        break;
                    }
                    case VARIABLE_BINARY: {
                        Slice slice = this.getSlice(index);
                        values.add(slice.toString(Charsets.UTF_8));
                    }
                }
            }
            ++index;
        }
        return Collections.unmodifiableList(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return this.slice.equals((Object)tuple.slice);
    }

    public int hashCode() {
        int result = this.slice.hashCode();
        return result;
    }

    public String toString() {
        String value = Joiner.on((String)",").useForNull("NULL").join(this.toValues()).replace("\n", "\\n");
        return Objects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("tupleInfo", (Object)this.tupleInfo).add("value", (Object)("{" + value + "}")).toString();
    }
}

