/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import java.util.List;

public class DirectFieldOrderedTupleComparator
extends AbstractIntComparator {
    private final TupleInfo tupleInfo;
    private final Slice slice;
    private final TupleInfo.Type[] types;

    public DirectFieldOrderedTupleComparator(TupleInfo tupleInfo, Slice slice) {
        this.tupleInfo = tupleInfo;
        this.slice = slice;
        List<TupleInfo.Type> types = tupleInfo.getTypes();
        this.types = types.toArray(new TupleInfo.Type[types.size()]);
    }

    public int compare(int left, int right) {
        Preconditions.checkArgument((left >= 0 && right >= 0 ? 1 : 0) != 0);
        for (int field = 0; field < this.types.length; ++field) {
            int comparison;
            TupleInfo.Type type = this.types[field];
            switch (type) {
                case BOOLEAN: {
                    comparison = Boolean.compare(this.tupleInfo.getBoolean(this.slice, left, field), this.tupleInfo.getBoolean(this.slice, right, field));
                    break;
                }
                case FIXED_INT_64: {
                    comparison = Long.compare(this.tupleInfo.getLong(this.slice, left, field), this.tupleInfo.getLong(this.slice, right, field));
                    break;
                }
                case DOUBLE: {
                    comparison = Double.compare(this.tupleInfo.getDouble(this.slice, left, field), this.tupleInfo.getDouble(this.slice, right, field));
                    break;
                }
                case VARIABLE_BINARY: {
                    comparison = this.tupleInfo.getSlice(this.slice, left, field).compareTo(this.tupleInfo.getSlice(this.slice, right, field));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unimplemented type: " + type));
                }
            }
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }
}

