/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class TpchMetadata
implements ConnectorMetadata {
    public static final String TPCH_CATALOG_NAME = "tpch";
    public static final String TPCH_SCHEMA_NAME = "default";
    public static final String TPCH_ORDERS_NAME = "orders";
    public static final ConnectorTableMetadata TPCH_ORDERS_METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder("default", "orders").column("orderkey", ColumnType.LONG).column("custkey", ColumnType.LONG).column("orderstatus", ColumnType.STRING).column("totalprice", ColumnType.DOUBLE).column("orderdate", ColumnType.STRING).column("orderpriority", ColumnType.STRING).column("clerk", ColumnType.STRING).column("shippriority", ColumnType.LONG).column("comment", ColumnType.STRING).build();
    public static final String TPCH_LINEITEM_NAME = "lineitem";
    public static final ConnectorTableMetadata TPCH_LINEITEM_METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder("default", "lineitem").column("orderkey", ColumnType.LONG).column("partkey", ColumnType.LONG).column("suppkey", ColumnType.LONG).column("linenumber", ColumnType.LONG).column("quantity", ColumnType.DOUBLE).column("extendedprice", ColumnType.DOUBLE).column("discount", ColumnType.DOUBLE).column("tax", ColumnType.DOUBLE).column("returnflag", ColumnType.STRING).column("linestatus", ColumnType.STRING).column("shipdate", ColumnType.STRING).column("commitdate", ColumnType.STRING).column("receiptdate", ColumnType.STRING).column("shipinstruct", ColumnType.STRING).column("shipmode", ColumnType.STRING).column("comment", ColumnType.STRING).build();
    private final Map<String, ConnectorTableMetadata> tables = ImmutableMap.of((Object)"orders", (Object)TPCH_ORDERS_METADATA, (Object)"lineitem", (Object)TPCH_LINEITEM_METADATA);

    public static Metadata createTpchMetadata() {
        MetadataManager metadataManager = new MetadataManager();
        metadataManager.addConnectorMetadata(TPCH_CATALOG_NAME, TPCH_CATALOG_NAME, new TpchMetadata());
        return metadataManager;
    }

    @Inject
    public TpchMetadata() {
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof TpchTableHandle;
    }

    public List<String> listSchemaNames() {
        return ImmutableList.of((Object)TPCH_SCHEMA_NAME);
    }

    public TableHandle getTableHandle(SchemaTableName table) {
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        if (TPCH_SCHEMA_NAME.equals(table.getSchemaName()) && this.tables.containsKey(table.getTableName())) {
            return new TpchTableHandle(table.getTableName());
        }
        return null;
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        String tableName = this.getTableName(tableHandle);
        Preconditions.checkArgument((boolean)this.tables.containsKey(tableName), (String)"Table %s does not exist", (Object[])new Object[]{tableHandle});
        return this.tables.get(tableName);
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            if (!columnMetadata.getName().equals(columnName)) continue;
            return new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType());
        }
        return null;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() != null && !TPCH_SCHEMA_NAME.equals(prefix.getSchemaName())) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(prefix.getSchemaName())) {
            int position = 1;
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : this.tables.get(tableName.getTableName()).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType(), position, false));
                ++position;
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        String tableName = this.getTableName(tableHandle);
        Preconditions.checkArgument((boolean)this.tables.containsKey(tableName), (String)"Table %s does not exist", (Object[])new Object[]{tableHandle});
        Preconditions.checkArgument((boolean)(columnHandle instanceof TpchColumnHandle), (Object)"columnHandle is not an instance of TpchColumnHandle");
        String columnName = ((TpchColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : this.tables.get(tableName).getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table %s does not have column %s", tableName, columnName));
    }

    public List<SchemaTableName> listTables(@Nullable String schemaNameOrNull) {
        if (schemaNameOrNull == null || TPCH_SCHEMA_NAME.equals(schemaNameOrNull)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String tableName : this.tables.keySet()) {
                builder.add((Object)new SchemaTableName(TPCH_SCHEMA_NAME, tableName));
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    public TableHandle createTable(ConnectorTableMetadata tableMetadata) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(TableHandle tableHandle) {
        throw new UnsupportedOperationException();
    }

    private String getTableName(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof TpchTableHandle), (Object)"tableHandle is not an instance of TpchTableHandle");
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        return tpchTableHandle.getTableName();
    }
}

