/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.connector.StaticConnector;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.tpch.TpchBlocksProvider;
import com.facebook.presto.tpch.TpchDataStreamProvider;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchSplitManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Map;
import javax.inject.Inject;

public class TpchConnectorFactory
implements ConnectorFactory {
    private static final TpchHandleResolver HANDLE_RESOLVER = new TpchHandleResolver();
    private final NodeManager nodeManager;
    private final TpchBlocksProvider tpchBlocksProvider;

    @Inject
    public TpchConnectorFactory(NodeManager nodeManager, TpchBlocksProvider tpchBlocksProvider) {
        this.tpchBlocksProvider = tpchBlocksProvider;
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public String getName() {
        return "tpch";
    }

    public Connector create(String connectorId, Map<String, String> properties) {
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        builder.put(ConnectorMetadata.class, (Object)new TpchMetadata());
        builder.put(ConnectorSplitManager.class, (Object)new TpchSplitManager(connectorId, this.nodeManager));
        builder.put(ConnectorDataStreamProvider.class, (Object)new TpchDataStreamProvider(this.tpchBlocksProvider));
        builder.put(ConnectorHandleResolver.class, (Object)HANDLE_RESOLVER);
        return new StaticConnector((Map<Class<?>, ?>)builder.build());
    }
}

