/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

public class TpchColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final int fieldIndex;
    private final ColumnType type;

    @JsonCreator
    public TpchColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="fieldIndex") int fieldIndex, @JsonProperty(value="type") ColumnType type) {
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex must be at least zero");
        this.fieldIndex = fieldIndex;
        this.type = (ColumnType)Preconditions.checkNotNull((Object)type, (Object)"type is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @JsonProperty
    public ColumnType getType() {
        return this.type;
    }

    public String toString() {
        return "tpch:" + this.columnName + ":" + this.fieldIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TpchColumnHandle)) {
            return false;
        }
        TpchColumnHandle that = (TpchColumnHandle)o;
        if (this.fieldIndex != that.fieldIndex) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.fieldIndex;
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

