/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.ColumnFileHandle;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.RecordProjectOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchDataFileLoader;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.util.DelimitedRecordSet;
import com.facebook.presto.util.Threads;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarFile;

public class GeneratingTpchDataFileLoader
implements TpchDataFileLoader {
    private final TableInputSupplierFactory tableInputSupplierFactory;
    private final File cacheDirectory;

    public GeneratingTpchDataFileLoader(TableInputSupplierFactory tableInputSupplierFactory, File cacheDirectory) {
        Preconditions.checkNotNull((Object)tableInputSupplierFactory, (Object)"tableInputStreamProvider is null");
        Preconditions.checkNotNull((Object)cacheDirectory, (Object)"cacheDirectory is null");
        Preconditions.checkArgument((!cacheDirectory.exists() || cacheDirectory.isDirectory() ? 1 : 0) != 0, (Object)"cacheDirectory must be a directory");
        this.tableInputSupplierFactory = tableInputSupplierFactory;
        this.cacheDirectory = cacheDirectory;
    }

    public GeneratingTpchDataFileLoader(TableInputSupplierFactory tableInputSupplierFactory, String cacheDirectoryName) {
        this(tableInputSupplierFactory, new File((String)Preconditions.checkNotNull((Object)cacheDirectoryName, (Object)"cacheDirectoryName is null")));
    }

    public GeneratingTpchDataFileLoader(String cacheDirectoryName) {
        this(GeneratingTpchDataFileLoader.autoSelectTableInputStreamProvider(), cacheDirectoryName);
    }

    public GeneratingTpchDataFileLoader() {
        this(System.getProperty("tpchCacheDir", "/tmp/tpchdatacache"));
    }

    private static TableInputSupplierFactory autoSelectTableInputStreamProvider() {
        String tpchDataJarFileOverride = System.getProperty("tpchDataJar");
        if (tpchDataJarFileOverride != null) {
            return new JarTableInputSupplierFactory(tpchDataJarFileOverride);
        }
        return new ResourcesTableInputSupplierFactory();
    }

    @Override
    public File getDataFile(TpchTableHandle tableHandle, TpchColumnHandle columnHandle, BlocksFileEncoding encoding) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null");
        String tableName = tableHandle.getTableName();
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed("tpch-generate-%s"));
        try {
            String hash = ByteStreams.hash((InputSupplier)ByteStreams.slice(this.tableInputSupplierFactory.getInputSupplier(tableName), (long)0L, (long)0x100000L), (HashFunction)Hashing.murmur3_32()).toString();
            File cachedFile = new File(new File(this.cacheDirectory, tableName + "-" + hash), "new-" + GeneratingTpchDataFileLoader.createFileName(columnHandle, encoding));
            if (cachedFile.exists()) {
                File file = cachedFile;
                return file;
            }
            Files.createParentDirs((File)cachedFile);
            InputSupplier<InputStream> inputSupplier = this.tableInputSupplierFactory.getInputSupplier(tableName);
            ColumnMetadata columnMetadata = new TpchMetadata().getColumnMetadata(tableHandle, columnHandle);
            DelimitedRecordSet records = new DelimitedRecordSet((InputSupplier<? extends Reader>)CharStreams.newReaderSupplier(inputSupplier, (Charset)Charsets.UTF_8), Splitter.on((String)"|"), columnMetadata);
            Session session = new Session("user", "source", "catalog", "schema", "address", "agent");
            OperatorContext operatorContext = new TaskContext(new TaskId("query", "stage", "task"), executor, session).addPipelineContext(true, true).addDriverContext().addOperatorContext(0, "tpch-generate");
            RecordProjectOperator source = new RecordProjectOperator(operatorContext, records);
            ColumnFileHandle columnFileHandle = ColumnFileHandle.builder(UUID.randomUUID()).addColumn(columnHandle, cachedFile, encoding).build();
            while (!source.isFinished()) {
                Page page = source.getOutput();
                if (page == null) continue;
                columnFileHandle.append(page);
            }
            columnFileHandle.commit();
            File file = cachedFile;
            return file;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static String createTableFileName(String tableName) {
        return tableName + ".tbl";
    }

    private static String createFileName(TpchColumnHandle columnHandle, BlocksFileEncoding encoding) {
        return String.format("column%d.%s_%s.data", columnHandle.getFieldIndex(), columnHandle.getType(), encoding.getName());
    }

    private static class ResourcesTableInputSupplierFactory
    implements TableInputSupplierFactory {
        private ResourcesTableInputSupplierFactory() {
        }

        @Override
        public InputSupplier<InputStream> getInputSupplier(String tableName) {
            Preconditions.checkNotNull((Object)tableName, (Object)"tableFileName is null");
            return Resources.newInputStreamSupplier((URL)Resources.getResource((String)GeneratingTpchDataFileLoader.createTableFileName(tableName)));
        }
    }

    private static class JarTableInputSupplierFactory
    implements TableInputSupplierFactory {
        private final String jarFileName;

        private JarTableInputSupplierFactory(String jarFileName) {
            this.jarFileName = (String)Preconditions.checkNotNull((Object)jarFileName, (Object)"jarFileName is null");
        }

        @Override
        public InputSupplier<InputStream> getInputSupplier(final String tableName) {
            Preconditions.checkNotNull((Object)tableName, (Object)"tableFileName is null");
            return new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    try {
                        JarFile jarFile = new JarFile(JarTableInputSupplierFactory.this.jarFileName);
                        return jarFile.getInputStream(jarFile.getJarEntry(GeneratingTpchDataFileLoader.createTableFileName(tableName)));
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
    }

    private static interface TableInputSupplierFactory {
        public InputSupplier<InputStream> getInputSupplier(String var1);
    }
}

