/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.serde.BlocksFileEncoding;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchDataFileLoader;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CachingTpchDataFileLoader
implements TpchDataFileLoader {
    private final Map<TpchColumnRequest, File> localFileCache = new HashMap<TpchColumnRequest, File>();
    private final TpchDataFileLoader delegate;

    public CachingTpchDataFileLoader(TpchDataFileLoader delegate) {
        this.delegate = (TpchDataFileLoader)Preconditions.checkNotNull((Object)delegate, (Object)"delegate is null");
    }

    @Override
    public File getDataFile(TpchTableHandle tableHandle, TpchColumnHandle columnHandle, BlocksFileEncoding encoding) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)((Object)encoding), (Object)"encoding is null");
        TpchColumnRequest columnRequest = new TpchColumnRequest(tableHandle, columnHandle, encoding.getName());
        File file = this.localFileCache.get(columnRequest);
        if (file == null) {
            file = this.delegate.getDataFile(tableHandle, columnHandle, encoding);
            this.localFileCache.put(columnRequest, file);
        }
        return file;
    }

    private static final class TpchColumnRequest {
        private final TpchTableHandle tableHandle;
        private final TpchColumnHandle columnHandle;
        private final String serdeName;

        private TpchColumnRequest(TpchTableHandle tableHandle, TpchColumnHandle columnHandle, String serdeName) {
            this.tableHandle = (TpchTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
            this.columnHandle = (TpchColumnHandle)Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
            this.serdeName = (String)Preconditions.checkNotNull((Object)serdeName, (Object)"serdeName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TpchColumnRequest)) {
                return false;
            }
            TpchColumnRequest that = (TpchColumnRequest)o;
            if (!this.columnHandle.equals(that.columnHandle)) {
                return false;
            }
            if (!this.serdeName.equals(that.serdeName)) {
                return false;
            }
            return this.tableHandle.equals(that.tableHandle);
        }

        public int hashCode() {
            int result = this.tableHandle.hashCode();
            result = 31 * result + this.columnHandle.hashCode();
            result = 31 * result + this.serdeName.hashCode();
            return result;
        }
    }
}

