/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SortItem;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortItem.Ordering> orderings;
    private final Map<Symbol, FunctionCall> windowFunctions;
    private final Map<Symbol, FunctionHandle> functionHandles;

    @JsonCreator
    public WindowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortItem.Ordering> orderings, @JsonProperty(value="windowFunctions") Map<Symbol, FunctionCall> windowFunctions, @JsonProperty(value="functionHandles") Map<Symbol, FunctionHandle> functionHandles) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
        Preconditions.checkNotNull(windowFunctions, (Object)"windowFunctions is null");
        Preconditions.checkNotNull(functionHandles, (Object)"functionHandles is null");
        Preconditions.checkArgument((boolean)windowFunctions.keySet().equals(functionHandles.keySet()), (Object)"windowFunctions does not match functionHandles");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.functionHandles = ImmutableMap.copyOf(functionHandles);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public Map<Symbol, SortItem.Ordering> getOrderings() {
        return this.orderings;
    }

    @JsonProperty
    public Map<Symbol, FunctionCall> getWindowFunctions() {
        return this.windowFunctions;
    }

    @JsonProperty
    public Map<Symbol, FunctionHandle> getFunctionHandles() {
        return this.functionHandles;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitWindow(this, context);
    }
}

