/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final Optional<GeneratedPartitions> generatedPartitions;
    private final boolean partitionsDroppedBySerialization;
    private final TupleDomain partitionDomainSummary;
    private final Expression originalConstraint;

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, @Nullable Expression originalConstraint, Optional<GeneratedPartitions> generatedPartitions) {
        this(id, table, outputSymbols, assignments, originalConstraint, generatedPartitions, false);
    }

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="originalConstraint") @Nullable Expression originalConstraint) {
        this(id, table, outputSymbols, assignments, originalConstraint, (Optional<GeneratedPartitions>)Optional.absent(), true);
    }

    private TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, @Nullable Expression originalConstraint, Optional<GeneratedPartitions> generatedPartitions, boolean partitionsDroppedBySerialization) {
        super(id);
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(outputSymbols, (Object)"outputSymbols is null");
        Preconditions.checkNotNull(assignments, (Object)"assignments is null");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputSymbols), (Object)"assignments does not cover all of outputSymbols");
        Preconditions.checkArgument((!assignments.isEmpty() ? 1 : 0) != 0, (Object)"assignments is empty");
        Preconditions.checkNotNull(generatedPartitions, (Object)"generatedPartitions is null");
        this.table = table;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.assignments = ImmutableMap.copyOf(assignments);
        this.originalConstraint = originalConstraint;
        this.generatedPartitions = generatedPartitions;
        this.partitionsDroppedBySerialization = partitionsDroppedBySerialization;
        this.partitionDomainSummary = TableScanNode.computePartitionsDomainSummary(generatedPartitions);
        Preconditions.checkArgument((this.partitionDomainSummary.isNone() || assignments.values().containsAll(this.partitionDomainSummary.getDomains().keySet()) ? 1 : 0) != 0, (Object)"Assignments do not include all of the ColumnHandles specified by the Partitions");
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @Nullable
    @JsonProperty(value="originalConstraint")
    public Expression getOriginalConstraint() {
        return this.originalConstraint;
    }

    public Optional<GeneratedPartitions> getGeneratedPartitions() {
        Preconditions.checkState((!this.partitionsDroppedBySerialization ? 1 : 0) != 0, (Object)"Can't access partitions after passing through serialization");
        return this.generatedPartitions;
    }

    public TupleDomain getPartitionsDomainSummary() {
        return this.partitionDomainSummary;
    }

    private static TupleDomain computePartitionsDomainSummary(Optional<GeneratedPartitions> generatedPartitions) {
        if (!generatedPartitions.isPresent()) {
            return TupleDomain.all();
        }
        TupleDomain tupleDomain = TupleDomain.none();
        for (Partition partition : ((GeneratedPartitions)generatedPartitions.get()).getPartitions()) {
            tupleDomain = tupleDomain.columnWiseUnion(partition.getTupleDomain());
        }
        return tupleDomain;
    }

    @JsonProperty(value="partitionDomainSummary")
    public String getPrintablePartitionDomainSummary() {
        StringBuilder builder = new StringBuilder().append("TupleDomain:");
        if (this.partitionDomainSummary.isAll()) {
            builder.append("ALL");
        } else if (this.partitionDomainSummary.isNone()) {
            builder.append("NONE");
        } else {
            builder.append(Maps.transformValues(DomainUtils.columnHandleToSymbol(this.partitionDomainSummary.getDomains(), this.assignments), DomainUtils.simplifyDomainFunction()));
        }
        return builder.toString();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public static final class GeneratedPartitions {
        private final TupleDomain tupleDomainInput;
        private final List<Partition> partitions;

        public GeneratedPartitions(TupleDomain tupleDomainInput, List<Partition> partitions) {
            this.tupleDomainInput = (TupleDomain)Preconditions.checkNotNull((Object)tupleDomainInput, (Object)"tupleDomainInput is null");
            this.partitions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitions, (Object)"partitions is null")));
        }

        public TupleDomain getTupleDomainInput() {
            return this.tupleDomainInput;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.tupleDomainInput, this.partitions});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedPartitions other = (GeneratedPartitions)obj;
            return Objects.equal((Object)this.tupleDomainInput, (Object)other.tupleDomainInput) && Objects.equal(this.partitions, other.partitions);
        }
    }
}

