/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Expression> outputs;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Map<Symbol, Expression> outputs) {
        super(id);
        this.source = source;
        this.outputs = outputs;
    }

    public List<Expression> getExpressions() {
        return ImmutableList.copyOf(this.outputs.values());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf(this.outputs.keySet());
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, Expression> getOutputMap() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitProject(this, context);
    }
}

