/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MaterializedViewWriterNode
extends PlanNode {
    private final PlanNode source;
    private final TableHandle tableHandle;
    private final Symbol output;
    private final Map<Symbol, ColumnHandle> columns;

    @JsonCreator
    public MaterializedViewWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="columns") Map<Symbol, ColumnHandle> columns, @JsonProperty(value="output") Symbol output) {
        super(id);
        this.columns = columns;
        this.output = output;
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.tableHandle = table;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableHandle getTable() {
        return this.tableHandle;
    }

    @JsonProperty
    public Map<Symbol, ColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Symbol getOutput() {
        return this.output;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.output);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitMaterializedViewWriter(this, context);
    }
}

