/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.FunctionHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MaterializedViewWriterNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UnaliasSymbolReferences
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(new HashMap<Symbol, Symbol>()), plan);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private final Map<Symbol, Symbol> mapping;

        public Rewriter(Map<Symbol, Symbol> mapping) {
            this.mapping = mapping;
        }

        @Override
        public PlanNode rewriteMaterializedViewWriter(MaterializedViewWriterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder columns = ImmutableMap.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getColumns().entrySet()) {
                columns.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new MaterializedViewWriterNode(node.getId(), source, node.getTable(), (Map<Symbol, ColumnHandle>)columns.build(), this.canonicalize(node.getOutput()));
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                functionCalls.put((Object)canonical, (Object)((FunctionCall)this.canonicalize((Expression)entry.getValue())));
                functionInfos.put((Object)canonical, (Object)node.getFunctions().get(symbol));
            }
            ImmutableList groupByKeys = ImmutableList.copyOf((Collection)ImmutableSet.copyOf(this.canonicalize(node.getGroupBy())));
            return new AggregationNode(node.getId(), source, (List<Symbol>)groupByKeys, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, FunctionHandle>)functionInfos.build());
        }

        @Override
        public PlanNode rewriteWindow(WindowNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                functionCalls.put((Object)canonical, (Object)((FunctionCall)this.canonicalize((Expression)entry.getValue())));
                functionInfos.put((Object)canonical, (Object)node.getFunctionHandles().get(symbol));
            }
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Map.Entry<Symbol, SortItem.Ordering> entry : node.getOrderings().entrySet()) {
                orderings.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new WindowNode(node.getId(), source, this.canonicalize(node.getPartitionBy()), this.canonicalize(node.getOrderBy()), (Map<Symbol, SortItem.Ordering>)orderings.build(), (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, FunctionHandle>)functionInfos.build());
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Void context, PlanRewriter<Void> planRewriter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.canonicalize(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), this.canonicalize(node.getOutputSymbols()), (Map<Symbol, ColumnHandle>)builder.build(), originalConstraint, node.getGeneratedPartitions());
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
            for (Map.Entry<Symbol, Expression> entry : node.getOutputMap().entrySet()) {
                Symbol canonical;
                Symbol symbol;
                Expression expression = this.canonicalize(entry.getValue());
                if (entry.getValue() instanceof QualifiedNameReference && !(symbol = Symbol.fromQualifiedName(((QualifiedNameReference)entry.getValue()).getName())).equals(entry.getKey())) {
                    this.map(entry.getKey(), symbol);
                }
                if (assignments.containsKey(canonical = this.canonicalize(entry.getKey()))) continue;
                assignments.put(canonical, expression);
            }
            return new ProjectNode(node.getId(), source, assignments);
        }

        @Override
        public PlanNode rewriteOutput(OutputNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            List canonical = Lists.transform(node.getOutputSymbols(), this.canonicalizeFunction());
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode rewriteTopN(TopNNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new TopNNode(node.getId(), source, node.getCount(), (List<Symbol>)symbols.build(), (Map<Symbol, SortItem.Ordering>)orderings.build(), node.isPartial());
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new SortNode(node.getId(), source, (List<Symbol>)symbols.build(), (Map<Symbol, SortItem.Ordering>)orderings.build());
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode left = planRewriter.rewrite(node.getLeft(), context);
            PlanNode right = planRewriter.rewrite(node.getRight(), context);
            return new JoinNode(node.getId(), node.getType(), left, right, this.canonicalizeJoinCriteria(node.getCriteria()));
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            PlanNode filteringSource = planRewriter.rewrite(node.getFilteringSource(), context);
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinSymbol()), this.canonicalize(node.getFilteringSourceJoinSymbol()), this.canonicalize(node.getSemiJoinOutput()));
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Void context, PlanRewriter<Void> planRewriter) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)planRewriter.rewrite(source, context));
            }
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSources.build(), this.canonicalizeUnionSymbolMap(node.getSymbolMapping()));
        }

        private void map(Symbol symbol, Symbol canonical) {
            Preconditions.checkArgument((!symbol.equals(canonical) ? 1 : 0) != 0, (String)"Can't map symbol to itself: %s", (Object[])new Object[]{symbol});
            this.mapping.put(symbol, canonical);
        }

        private Symbol canonicalize(Symbol symbol) {
            Symbol canonical = symbol;
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return canonical;
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = Rewriter.this.canonicalize(Symbol.fromQualifiedName(node.getName()));
                    return new QualifiedNameReference(canonical.toQualifiedName());
                }
            }, (Expression)value);
        }

        private List<Symbol> canonicalize(List<Symbol> outputs) {
            return Lists.transform(outputs, this.canonicalizeFunction());
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private ListMultimap<Symbol, Symbol> canonicalizeUnionSymbolMap(ListMultimap<Symbol, Symbol> unionSymbolMap) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (Map.Entry entry : unionSymbolMap.asMap().entrySet()) {
                builder.putAll((Object)this.canonicalize((Symbol)entry.getKey()), Iterables.transform((Iterable)((Iterable)entry.getValue()), this.canonicalizeFunction()));
            }
            return builder.build();
        }

        private Function<Symbol, Symbol> canonicalizeFunction() {
            return new Function<Symbol, Symbol>(){

                public Symbol apply(Symbol input) {
                    return Rewriter.this.canonicalize(input);
                }
            };
        }
    }
}

