/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.AliasDao;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.TableAlias;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.MaterializedViewWriterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TableAliasSelector
extends PlanOptimizer {
    private final Metadata metadata;
    private final AliasDao aliasDao;
    private final NodeManager nodeManager;
    private final ShardManager shardManager;

    public TableAliasSelector(Metadata metadata, AliasDao aliasDao, NodeManager nodeManager, ShardManager shardManager) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.aliasDao = (AliasDao)Preconditions.checkNotNull((Object)aliasDao, (Object)"aliasDao is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        if (TableAliasSelector.containsMaterializedViewWriter(plan)) {
            return plan;
        }
        return PlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static boolean containsMaterializedViewWriter(PlanNode plan) {
        if (plan == null) {
            return false;
        }
        if (plan instanceof MaterializedViewWriterNode) {
            return true;
        }
        for (PlanNode sourceNode : plan.getSources()) {
            if (!TableAliasSelector.containsMaterializedViewWriter(sourceNode)) continue;
            return true;
        }
        return false;
    }

    private class Rewriter
    extends PlanNodeRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode rewriteTableScan(TableScanNode node, Void context, PlanRewriter<Void> planRewriter) {
            TableHandle tableHandle = node.getTable();
            String connectorId = TableAliasSelector.this.metadata.getConnectorId(tableHandle);
            SchemaTableName tableName = TableAliasSelector.this.metadata.getTableMetadata(tableHandle).getTable();
            TableAlias tableAlias = TableAliasSelector.this.aliasDao.getAlias(connectorId, tableName.getSchemaName(), tableName.getTableName());
            if (tableAlias == null) {
                return node;
            }
            Optional<TableHandle> aliasTableHandle = TableAliasSelector.this.metadata.getTableHandle(tableAlias.getDestinationConnectorId(), new SchemaTableName(tableAlias.getDestinationSchemaName(), tableAlias.getDestinationTableName()));
            if (!aliasTableHandle.isPresent()) {
                return node;
            }
            if (!this.allNodesPresent((TableHandle)aliasTableHandle.get())) {
                return node;
            }
            Map<String, ColumnHandle> lookupColumns = TableAliasSelector.this.metadata.getColumnHandles((TableHandle)aliasTableHandle.get());
            Map<Symbol, ColumnHandle> assignments = node.getAssignments();
            ImmutableMap.Builder newAssignmentsBuilder = ImmutableMap.builder();
            for (Map.Entry<Symbol, ColumnHandle> assignmentEntry : assignments.entrySet()) {
                ColumnMetadata originalColumn = TableAliasSelector.this.metadata.getColumnMetadata(tableHandle, assignmentEntry.getValue());
                ColumnHandle aliasedColumnHandle = lookupColumns.get(originalColumn.getName());
                Preconditions.checkState((aliasedColumnHandle != null ? 1 : 0) != 0, (String)"no matching column for original column %s found!", (Object[])new Object[]{originalColumn});
                newAssignmentsBuilder.put((Object)assignmentEntry.getKey(), (Object)aliasedColumnHandle);
            }
            return new TableScanNode(node.getId(), (TableHandle)aliasTableHandle.get(), node.getOutputSymbols(), (Map<Symbol, ColumnHandle>)newAssignmentsBuilder.build(), node.getOriginalConstraint(), node.getGeneratedPartitions());
        }

        private boolean allNodesPresent(TableHandle tableHandle) {
            ImmutableSet nodesActive = ImmutableSet.copyOf((Collection)Collections2.transform(TableAliasSelector.this.nodeManager.getAllNodes().getActiveNodes(), Node.getIdentifierFunction()));
            Set<String> nodesRequired = TableAliasSelector.this.shardManager.getTableNodes(tableHandle);
            return nodesActive.containsAll(nodesRequired);
        }
    }
}

