/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class ImplementSampleAsFilter
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(), plan, null);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode rewriteSample(SampleNode node, Void context, PlanRewriter<Void> planRewriter) {
            if (node.getSampleType() == SampleNode.Type.BERNOULLI) {
                PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), context);
                ComparisonExpression expression = new ComparisonExpression(ComparisonExpression.Type.LESS_THAN, (Expression)new FunctionCall(QualifiedName.of((String)"rand", (String[])new String[0]), (List)ImmutableList.of()), (Expression)new DoubleLiteral(Double.toString(node.getSampleRatio())));
                return new FilterNode(node.getId(), rewrittenSource, (Expression)expression);
            }
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return this.rewriteNode(node, context, planRewriter);
            }
            throw new UnsupportedOperationException("not yet implemented");
        }
    }
}

