/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SubPlanBuilder {
    private final PlanFragmentId id;
    private final SymbolAllocator allocator;
    private final PlanFragment.PlanDistribution distribution;
    private final PlanNodeId partitionedSource;
    private PlanNode root;
    private List<SubPlan> children = new ArrayList<SubPlan>();
    private PlanFragment.OutputPartitioning outputPartitioning = PlanFragment.OutputPartitioning.NONE;

    public SubPlanBuilder(PlanFragmentId id, SymbolAllocator allocator, PlanFragment.PlanDistribution distribution, PlanNode root, PlanNodeId partitionedSource) {
        this.id = (PlanFragmentId)Preconditions.checkNotNull((Object)id, (Object)"id is null");
        this.allocator = (SymbolAllocator)Preconditions.checkNotNull((Object)allocator, (Object)"allocator is null");
        this.distribution = (PlanFragment.PlanDistribution)((Object)Preconditions.checkNotNull((Object)((Object)distribution), (Object)"distribution is null"));
        this.root = (PlanNode)Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.partitionedSource = partitionedSource;
    }

    public PlanFragmentId getId() {
        return this.id;
    }

    public boolean isDistributed() {
        return this.distribution != PlanFragment.PlanDistribution.NONE;
    }

    public PlanFragment.PlanDistribution getDistribution() {
        return this.distribution;
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public SubPlanBuilder setRoot(PlanNode root) {
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.root = root;
        return this;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public SubPlanBuilder setChildren(Iterable<SubPlan> children) {
        this.children = Lists.newArrayList(children);
        return this;
    }

    public SubPlanBuilder addChild(SubPlan child) {
        this.children.add(child);
        return this;
    }

    public SubPlanBuilder setOutputPartitioning(PlanFragment.OutputPartitioning outputPartitioning) {
        this.outputPartitioning = outputPartitioning;
        return this;
    }

    public SubPlan build() {
        Set<Symbol> dependencies = SymbolExtractor.extract(this.root);
        PlanFragment fragment = new PlanFragment(this.id, this.root, Maps.filterKeys(this.allocator.getTypes(), (Predicate)Predicates.in(dependencies)), this.distribution, this.partitionedSource, this.outputPartitioning);
        return new SubPlan(fragment, this.children);
    }
}

