/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.operator.MaterializedViewWriterResult;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionKey;
import com.facebook.presto.spi.PartitionedSplit;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.CollocatedSplit;
import com.facebook.presto.split.NativeSplit;
import com.facebook.presto.sql.planner.OutputReceiver;
import com.facebook.presto.sql.planner.plan.MaterializedViewWriterNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MaterializedViewWriter {
    private final MaterializedViewWriterNode writerNode;
    private final ShardManager shardManager;
    private final Map<String, PartitionInfo> openPartitions = new ConcurrentHashMap<String, PartitionInfo>();
    private final Map<String, PartitionInfo> finishedPartitions = new ConcurrentHashMap<String, PartitionInfo>();
    private final Map<UUID, String> shardsDone = new ConcurrentHashMap<UUID, String>();
    private final Set<String> partitionsDone = Sets.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger shardsInFlight = new AtomicInteger();
    private final AtomicBoolean predicateHandedOut = new AtomicBoolean();
    private final Set<String> remainingPartitions = Sets.newSetFromMap(new ConcurrentHashMap());

    MaterializedViewWriter(MaterializedViewWriterNode writerNode, ShardManager shardManager) {
        this.writerNode = (MaterializedViewWriterNode)Preconditions.checkNotNull((Object)writerNode, (Object)"writerNode is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        this.remainingPartitions.addAll(Collections2.transform(shardManager.getPartitions(writerNode.getTable()), TablePartition.partitionNameGetter()));
    }

    public OutputReceiver getOutputReceiver() {
        return new OutputReceiver(){

            @Override
            public void updateOutput(Object result) {
                MaterializedViewWriterResult writerResult = MaterializedViewWriterResult.forMap((Map)result);
                String oldValue = MaterializedViewWriter.this.shardsDone.put(writerResult.getShardUuid(), writerResult.getNodeIdentifier());
                Preconditions.checkState((oldValue == null || oldValue.equals(writerResult.getNodeIdentifier()) ? 1 : 0) != 0, (String)"Seen a different node committing a shard (%s vs %s)", (Object[])new Object[]{oldValue, writerResult.getNodeIdentifier()});
                for (Map.Entry entry : MaterializedViewWriter.this.finishedPartitions.entrySet()) {
                    if (MaterializedViewWriter.this.partitionsDone.contains(entry.getKey())) continue;
                    MaterializedViewWriter.this.considerCommittingPartition((String)entry.getKey(), (PartitionInfo)entry.getValue());
                }
            }
        };
    }

    private synchronized void considerCommittingPartition(String partitionName, PartitionInfo partitionInfo) {
        if (this.partitionsDone.contains(partitionName)) {
            return;
        }
        Set<UUID> shardUuids = partitionInfo.getShardUuids();
        if (this.shardsDone.keySet().containsAll(shardUuids)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (UUID shardUuid : shardUuids) {
                builder.put((Object)shardUuid, (Object)this.shardsDone.get(shardUuid));
            }
            ImmutableMap shards = builder.build();
            this.shardManager.commitPartition(this.writerNode.getTable(), partitionName, partitionInfo.getPartitionKeys(), (Map<UUID, String>)shards);
            Preconditions.checkState((this.shardsInFlight.addAndGet(-shardUuids.size()) >= 0 ? 1 : 0) != 0, (Object)"shards in flight crashed into the ground");
            this.partitionsDone.add(partitionName);
        }
    }

    public Iterable<Split> wrapSplits(PlanNodeId planNodeId, Iterable<Split> splits) {
        return new WriterIterable(planNodeId, splits);
    }

    private void addPartitionShard(String partition, boolean lastSplit, List<? extends PartitionKey> partitionKeys, UUID shardUuid) {
        PartitionInfo partitionInfo = this.openPartitions.get(partition);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (partitionInfo != null) {
            Set<UUID> partitionSplits = partitionInfo.getShardUuids();
            builder.addAll(partitionSplits);
        }
        if (shardUuid != null) {
            builder.add((Object)shardUuid);
        } else {
            Preconditions.checkState((boolean)lastSplit, (Object)"shardUuid == null and lastSplit unset!");
        }
        ImmutableSet shardUuids = builder.build();
        Preconditions.checkState((!shardUuids.isEmpty() ? 1 : 0) != 0, (String)"Never saw a split for partition %s", (Object[])new Object[]{partition});
        PartitionInfo newPartitionInfo = new PartitionInfo((Set)shardUuids, partitionKeys);
        if (lastSplit) {
            Preconditions.checkState((null == this.finishedPartitions.put(partition, newPartitionInfo) ? 1 : 0) != 0, (String)"Partition %s finished multiple times", (Object[])new Object[]{partition});
            this.openPartitions.remove(partition);
        } else {
            this.openPartitions.put(partition, newPartitionInfo);
        }
    }

    private void finishOpenPartitions() {
        for (String partition : this.openPartitions.keySet()) {
            this.addPartitionShard(partition, true, (List<? extends PartitionKey>)ImmutableList.of(), null);
        }
        Preconditions.checkState((boolean)this.openPartitions.isEmpty(), (String)"Still open partitions: %s", (Object[])new Object[]{this.openPartitions});
    }

    private void dropAdditionalPartitions() {
        for (String partition : this.remainingPartitions) {
            this.shardManager.dropPartition(this.writerNode.getTable(), partition);
        }
    }

    public Predicate<Partition> getPartitionPredicate() {
        Preconditions.checkState((!this.predicateHandedOut.getAndSet(true) ? 1 : 0) != 0, (Object)"Predicate can only be handed out once");
        ImmutableSet allPartitions = ImmutableSet.copyOf(this.remainingPartitions);
        return new Predicate<Partition>((Set)allPartitions){
            final /* synthetic */ Set val$allPartitions;
            {
                this.val$allPartitions = set;
            }

            public boolean apply(Partition input) {
                MaterializedViewWriter.this.remainingPartitions.remove(input.getPartitionId());
                return !this.val$allPartitions.contains(input.getPartitionId());
            }
        };
    }

    private static final class PartitionInfo {
        private final Set<UUID> shardUuids;
        private final List<? extends PartitionKey> partitionKeys;

        private PartitionInfo(Set<UUID> shardUuids, List<? extends PartitionKey> partitionKeys) {
            this.shardUuids = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(shardUuids, (Object)"shardUuids is null")));
            this.partitionKeys = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null")));
        }

        public Set<UUID> getShardUuids() {
            return this.shardUuids;
        }

        public List<? extends PartitionKey> getPartitionKeys() {
            return this.partitionKeys;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("shardUuids", this.shardUuids).add("partitionKeys", this.partitionKeys).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.shardUuids, this.partitionKeys});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionInfo other = (PartitionInfo)obj;
            return Objects.equal(this.shardUuids, other.shardUuids) && Objects.equal(this.partitionKeys, other.partitionKeys);
        }
    }

    private class WriterIterator
    extends AbstractIterator<Split> {
        private final PlanNodeId planNodeId;
        private final Iterator<Split> sourceIterator;

        private WriterIterator(PlanNodeId planNodeId, Iterator<Split> sourceIterator) {
            this.planNodeId = planNodeId;
            this.sourceIterator = sourceIterator;
        }

        protected Split computeNext() {
            if (this.sourceIterator.hasNext()) {
                Split sourceSplit = this.sourceIterator.next();
                NativeSplit writingSplit = new NativeSplit(UUID.randomUUID(), (List<HostAddress>)ImmutableList.of());
                String partition = "unpartitioned";
                boolean lastSplit = false;
                Object partitionKeys = ImmutableList.of();
                if (sourceSplit instanceof PartitionedSplit) {
                    PartitionedSplit partitionedSplit = (PartitionedSplit)sourceSplit;
                    partition = partitionedSplit.getPartitionId();
                    lastSplit = partitionedSplit.isLastSplit();
                    partitionKeys = partitionedSplit.getPartitionKeys();
                }
                MaterializedViewWriter.this.addPartitionShard(partition, lastSplit, (List)partitionKeys, writingSplit.getShardUuid());
                CollocatedSplit collocatedSplit = new CollocatedSplit((Map<PlanNodeId, Split>)ImmutableMap.of((Object)this.planNodeId, (Object)sourceSplit, (Object)MaterializedViewWriter.this.writerNode.getId(), (Object)writingSplit), sourceSplit.getAddresses(), sourceSplit.isRemotelyAccessible());
                MaterializedViewWriter.this.shardsInFlight.incrementAndGet();
                return collocatedSplit;
            }
            MaterializedViewWriter.this.finishOpenPartitions();
            MaterializedViewWriter.this.dropAdditionalPartitions();
            return (Split)this.endOfData();
        }
    }

    private class WriterIterable
    implements Iterable<Split> {
        private final AtomicBoolean used = new AtomicBoolean();
        private final Iterable<Split> splits;
        private final PlanNodeId planNodeId;

        private WriterIterable(PlanNodeId planNodeId, Iterable<Split> splits) {
            this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
            this.splits = (Iterable)Preconditions.checkNotNull(splits, (Object)"splits is null");
        }

        @Override
        public Iterator<Split> iterator() {
            Preconditions.checkState((!this.used.getAndSet(true) ? 1 : 0) != 0, (Object)"The table writer can hand out only a single iterator");
            return new WriterIterator(this.planNodeId, this.splits.iterator());
        }
    }
}

