/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.DateLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class LiteralInterpreter {
    public static Object evaluate(Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor().process((Node)node, null);
    }

    public static List<Expression> toExpressions(List<?> objects) {
        return ImmutableList.copyOf((Collection)Lists.transform(objects, (Function)new Function<Object, Expression>(){

            public Expression apply(@Nullable Object value) {
                return LiteralInterpreter.toExpression(value);
            }
        }));
    }

    public static Expression toExpression(Object object) {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object instanceof Long) {
            return new LongLiteral(object.toString());
        }
        if (object instanceof Double) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCall(new QualifiedName("nan"), (List)ImmutableList.of());
            }
            if (value == Double.NEGATIVE_INFINITY) {
                return new NegativeExpression((Expression)new FunctionCall(new QualifiedName("infinity"), (List)ImmutableList.of()));
            }
            if (value == Double.POSITIVE_INFINITY) {
                return new FunctionCall(new QualifiedName("infinity"), (List)ImmutableList.of());
            }
            return new DoubleLiteral(object.toString());
        }
        if (object instanceof Slice) {
            return new StringLiteral(((Slice)object).toString(Charsets.UTF_8));
        }
        if (object instanceof String) {
            return new StringLiteral((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanLiteral(object.toString());
        }
        if (object == null) {
            return new NullLiteral();
        }
        throw new UnsupportedOperationException("not yet implemented: " + object.getClass().getName());
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, Void> {
        private LiteralVisitor() {
        }

        protected Object visitLiteral(Literal node, Void context) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Void context) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, Void context) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, Void context) {
            return node.getValue();
        }

        protected Slice visitStringLiteral(StringLiteral node, Void context) {
            return node.getSlice();
        }

        protected Object visitDateLiteral(DateLiteral node, Void context) {
            return node.getUnixTime();
        }

        protected Object visitTimeLiteral(TimeLiteral node, Void context) {
            return node.getUnixTime();
        }

        protected Long visitTimestampLiteral(TimestampLiteral node, Void context) {
            return node.getUnixTime();
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, Void context) {
            if (node.isYearToMonth()) {
                throw new UnsupportedOperationException("Month based intervals not supported yet: " + node.getType());
            }
            return node.getSeconds();
        }

        protected Object visitNullLiteral(NullLiteral node, Void context) {
            return null;
        }
    }
}

