/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleReadable;
import java.util.Map;

public class InterpretedFilterFunction
implements FilterFunction {
    private final ExpressionInterpreter evaluator;

    public InterpretedFilterFunction(Expression predicate, Map<Symbol, Input> symbolToInputMappings, Metadata metadata, Session session) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(symbolToInputMappings), (Expression)predicate);
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session);
    }

    @Override
    public boolean filter(TupleReadable ... cursors) {
        return this.evaluator.evaluate(cursors) == Boolean.TRUE;
    }

    @Override
    public boolean filter(RecordCursor cursor) {
        return this.evaluator.evaluate(cursor) == Boolean.TRUE;
    }
}

