/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.scalar.UnixTimeFunctions;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.Casts;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.LikeUtils;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;
import org.joni.Regex;

public class ExpressionInterpreter {
    private final Expression expression;
    private final Metadata metadata;
    private final Session session;
    private final boolean optimize;
    private final Visitor visitor;
    private final IdentityHashMap<LikePredicate, Regex> LIKE_PATTERN_CACHE = new IdentityHashMap();
    private final IdentityHashMap<InListExpression, Set<Object>> IN_LIST_CACHE = new IdentityHashMap();

    public static ExpressionInterpreter expressionInterpreter(Expression expression, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        return new ExpressionInterpreter(expression, metadata, session, false);
    }

    public static ExpressionInterpreter expressionOptimizer(Expression expression, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        return new ExpressionInterpreter(expression, metadata, session, true);
    }

    private ExpressionInterpreter(Expression expression, Metadata metadata, Session session, boolean optimize) {
        this.expression = expression;
        this.metadata = metadata;
        this.session = session;
        this.optimize = optimize;
        this.visitor = new Visitor();
    }

    public Object evaluate(RecordCursor inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(RecordCursor) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public Object evaluate(TupleReadable[] inputs) {
        Preconditions.checkState((!this.optimize ? 1 : 0) != 0, (Object)"evaluate(TupleReadable[]) not allowed for optimizer");
        return this.visitor.process((Node)this.expression, inputs);
    }

    public Object optimize(SymbolResolver inputs) {
        Preconditions.checkState((boolean)this.optimize, (Object)"evaluate(SymbolResolver) not allowed for interpreter");
        return this.visitor.process((Node)this.expression, inputs);
    }

    private static Predicate<Expression> isNonNullLiteralPredicate() {
        return new Predicate<Expression>(){

            public boolean apply(@Nullable Expression input) {
                return input instanceof Literal && !(input instanceof NullLiteral);
            }
        };
    }

    private class Visitor
    extends AstVisitor<Object, Object> {
        private Visitor() {
        }

        protected Object visitCurrentTime(CurrentTime node, Object context) {
            if (node.getType() != CurrentTime.Type.TIMESTAMP) {
                throw new UnsupportedOperationException("not yet implemented: " + node.getType());
            }
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            return UnixTimeFunctions.currentTimestamp(ExpressionInterpreter.this.session);
        }

        public Object visitInputReference(InputReference node, Object context) {
            Input input = node.getInput();
            int channel = input.getChannel();
            if (context instanceof TupleReadable[]) {
                TupleReadable[] inputs = (TupleReadable[])context;
                TupleReadable tuple = inputs[channel];
                int field = input.getField();
                if (tuple.isNull(field)) {
                    return null;
                }
                switch (tuple.getTupleInfo().getTypes().get(field)) {
                    case BOOLEAN: {
                        return tuple.getBoolean(field);
                    }
                    case FIXED_INT_64: {
                        return tuple.getLong(field);
                    }
                    case DOUBLE: {
                        return tuple.getDouble(field);
                    }
                    case VARIABLE_BINARY: {
                        return tuple.getSlice(field);
                    }
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            if (context instanceof RecordCursor) {
                RecordCursor cursor = (RecordCursor)context;
                Preconditions.checkArgument((input.getField() == 0 ? 1 : 0) != 0, (String)"Field for cursor must be 0 but is %s", (Object[])new Object[]{input.getField()});
                if (cursor.isNull(channel)) {
                    return null;
                }
                switch (cursor.getType(input.getChannel())) {
                    case BOOLEAN: {
                        return cursor.getBoolean(channel);
                    }
                    case LONG: {
                        return cursor.getLong(channel);
                    }
                    case DOUBLE: {
                        return cursor.getDouble(channel);
                    }
                    case STRING: {
                        return Slices.wrappedBuffer((byte[])cursor.getString(channel));
                    }
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
            throw new UnsupportedOperationException("Inputs or cursor myst be set");
        }

        protected Object visitQualifiedNameReference(QualifiedNameReference node, Object context) {
            if (node.getName().getPrefix().isPresent()) {
                return node;
            }
            Symbol symbol = Symbol.fromQualifiedName(node.getName());
            return ((SymbolResolver)context).getValue(symbol);
        }

        protected Object visitLiteral(Literal node, Object context) {
            return LiteralInterpreter.evaluate((Expression)node);
        }

        protected Object visitIsNullPredicate(IsNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return node;
            }
            return value == null;
        }

        protected Object visitIsNotNullPredicate(IsNotNullPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value instanceof Expression) {
                return node;
            }
            return value != null;
        }

        protected Object visitSearchedCaseExpression(SearchedCaseExpression node, Object context) {
            Expression resultClause = node.getDefaultValue();
            for (WhenClause whenClause : node.getWhenClauses()) {
                Object value = this.process((Node)whenClause.getOperand(), context);
                if (value instanceof Expression) {
                    return node;
                }
                if (!Boolean.TRUE.equals(value)) continue;
                resultClause = whenClause.getResult();
                break;
            }
            if (resultClause == null) {
                return null;
            }
            Object result = this.process((Node)resultClause, context);
            if (result instanceof Expression) {
                return node;
            }
            return result;
        }

        protected Object visitSimpleCaseExpression(SimpleCaseExpression node, Object context) {
            Object operand = this.process((Node)node.getOperand(), context);
            if (operand instanceof Expression) {
                return node;
            }
            Expression resultClause = node.getDefaultValue();
            if (operand != null) {
                for (WhenClause whenClause : node.getWhenClauses()) {
                    Object value = this.process((Node)whenClause.getOperand(), context);
                    if (value instanceof Expression) {
                        return node;
                    }
                    if (operand instanceof Long && value instanceof Long) {
                        if (((Long)operand).longValue() != ((Long)value).longValue()) continue;
                        resultClause = whenClause.getResult();
                        break;
                    }
                    if (operand instanceof Number && value instanceof Number) {
                        if (((Number)operand).doubleValue() != ((Number)value).doubleValue()) continue;
                        resultClause = whenClause.getResult();
                        break;
                    }
                    if (!operand.equals(value)) continue;
                    resultClause = whenClause.getResult();
                    break;
                }
            }
            if (resultClause == null) {
                return null;
            }
            Object result = this.process((Node)resultClause, context);
            if (result instanceof Expression) {
                return node;
            }
            return result;
        }

        protected Object visitCoalesceExpression(CoalesceExpression node, Object context) {
            for (Expression expression : node.getOperands()) {
                Object value = this.process((Node)expression, context);
                if (value instanceof Expression) {
                    return node;
                }
                if (value == null) continue;
                return value;
            }
            return null;
        }

        protected Object visitInPredicate(InPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Expression valueListExpression = node.getValueList();
            if (!(valueListExpression instanceof InListExpression)) {
                if (!ExpressionInterpreter.this.optimize) {
                    throw new UnsupportedOperationException("IN predicate value list type not yet implemented: " + valueListExpression.getClass().getName());
                }
                return node;
            }
            InListExpression valueList = (InListExpression)valueListExpression;
            HashSet<Object> set = (HashSet<Object>)ExpressionInterpreter.this.IN_LIST_CACHE.get(valueList);
            if (!ExpressionInterpreter.this.IN_LIST_CACHE.containsKey(valueList)) {
                if (Iterables.all((Iterable)valueList.getValues(), (Predicate)ExpressionInterpreter.isNonNullLiteralPredicate())) {
                    set = new HashSet<Object>();
                    for (Expression expression : valueList.getValues()) {
                        set.add(this.process((Node)expression, context));
                    }
                }
                ExpressionInterpreter.this.IN_LIST_CACHE.put(valueList, set);
            }
            if (set != null && !(value instanceof Expression)) {
                return set.contains(value);
            }
            boolean hasUnresolvedValue = false;
            if (value instanceof Expression) {
                hasUnresolvedValue = true;
            }
            boolean hasNullValue = false;
            boolean found = false;
            ArrayList<Object> values = new ArrayList<Object>(valueList.getValues().size());
            for (Expression expression : valueList.getValues()) {
                Object inValue = this.process((Node)expression, context);
                if (value instanceof Expression || inValue instanceof Expression) {
                    hasUnresolvedValue = true;
                    values.add(inValue);
                    continue;
                }
                if (inValue == null) {
                    hasNullValue = true;
                    continue;
                }
                if (found || !value.equals(inValue)) continue;
                found = true;
            }
            if (found) {
                return true;
            }
            if (hasUnresolvedValue) {
                return new InPredicate(LiteralInterpreter.toExpression(value), (Expression)new InListExpression(LiteralInterpreter.toExpressions(values)));
            }
            if (hasNullValue) {
                return null;
            }
            return false;
        }

        protected Object visitNegativeExpression(NegativeExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return node;
            }
            if (value instanceof Long) {
                return -((Long)value).longValue();
            }
            return -((Double)value).doubleValue();
        }

        protected Object visitArithmeticExpression(ArithmeticExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (left instanceof Expression || right instanceof Expression) {
                return node;
            }
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            switch (node.getType()) {
                case ADD: {
                    if (leftNumber instanceof Long && rightNumber instanceof Long) {
                        return leftNumber.longValue() + rightNumber.longValue();
                    }
                    return leftNumber.doubleValue() + rightNumber.doubleValue();
                }
                case SUBTRACT: {
                    if (leftNumber instanceof Long && rightNumber instanceof Long) {
                        return leftNumber.longValue() - rightNumber.longValue();
                    }
                    return leftNumber.doubleValue() - rightNumber.doubleValue();
                }
                case DIVIDE: {
                    if (leftNumber instanceof Long && rightNumber instanceof Long) {
                        return leftNumber.longValue() / rightNumber.longValue();
                    }
                    return leftNumber.doubleValue() / rightNumber.doubleValue();
                }
                case MULTIPLY: {
                    if (leftNumber instanceof Long && rightNumber instanceof Long) {
                        return leftNumber.longValue() * rightNumber.longValue();
                    }
                    return leftNumber.doubleValue() * rightNumber.doubleValue();
                }
                case MODULUS: {
                    if (leftNumber instanceof Long && rightNumber instanceof Long) {
                        return leftNumber.longValue() % rightNumber.longValue();
                    }
                    return leftNumber.doubleValue() % rightNumber.doubleValue();
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getType());
        }

        protected Object visitComparisonExpression(ComparisonExpression node, Object context) {
            if (node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM) {
                Object left = this.process((Node)node.getLeft(), context);
                Object right = this.process((Node)node.getRight(), context);
                if (left == null && right == null) {
                    return false;
                }
                if (left == null || right == null) {
                    return true;
                }
                if (left instanceof Long && right instanceof Long) {
                    return ((Number)left).longValue() != ((Number)right).longValue();
                }
                if (left instanceof Number && right instanceof Number) {
                    return ((Number)left).doubleValue() != ((Number)right).doubleValue();
                }
                if (left instanceof Boolean && right instanceof Boolean) {
                    return !left.equals(right);
                }
                if (left instanceof Slice && right instanceof Slice) {
                    return !left.equals(right);
                }
                return new ComparisonExpression(node.getType(), LiteralInterpreter.toExpression(left), LiteralInterpreter.toExpression(right));
            }
            Object left = this.process((Node)node.getLeft(), context);
            if (left == null) {
                return null;
            }
            Object right = this.process((Node)node.getRight(), context);
            if (right == null) {
                return null;
            }
            if (left instanceof Long && right instanceof Long) {
                switch (node.getType()) {
                    case EQUAL: {
                        return ((Number)left).longValue() == ((Number)right).longValue();
                    }
                    case NOT_EQUAL: {
                        return ((Number)left).longValue() != ((Number)right).longValue();
                    }
                    case LESS_THAN: {
                        return ((Number)left).longValue() < ((Number)right).longValue();
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ((Number)left).longValue() <= ((Number)right).longValue();
                    }
                    case GREATER_THAN: {
                        return ((Number)left).longValue() > ((Number)right).longValue();
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ((Number)left).longValue() >= ((Number)right).longValue();
                    }
                }
                throw new UnsupportedOperationException("unhandled type: " + node.getType());
            }
            if (left instanceof Number && right instanceof Number) {
                switch (node.getType()) {
                    case EQUAL: {
                        return ((Number)left).doubleValue() == ((Number)right).doubleValue();
                    }
                    case NOT_EQUAL: {
                        return ((Number)left).doubleValue() != ((Number)right).doubleValue();
                    }
                    case LESS_THAN: {
                        return ((Number)left).doubleValue() < ((Number)right).doubleValue();
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
                    }
                    case GREATER_THAN: {
                        return ((Number)left).doubleValue() > ((Number)right).doubleValue();
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
                    }
                }
                throw new UnsupportedOperationException("unhandled type: " + node.getType());
            }
            if (left instanceof Slice && right instanceof Slice) {
                switch (node.getType()) {
                    case EQUAL: {
                        return left.equals(right);
                    }
                    case NOT_EQUAL: {
                        return !left.equals(right);
                    }
                    case LESS_THAN: {
                        return ((Slice)left).compareTo((Slice)right) < 0;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ((Slice)left).compareTo((Slice)right) <= 0;
                    }
                    case GREATER_THAN: {
                        return ((Slice)left).compareTo((Slice)right) > 0;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ((Slice)left).compareTo((Slice)right) >= 0;
                    }
                }
                throw new UnsupportedOperationException("unhandled type: " + node.getType());
            }
            if (left instanceof Boolean && right instanceof Boolean) {
                switch (node.getType()) {
                    case EQUAL: {
                        return left.equals(right);
                    }
                    case NOT_EQUAL: {
                        return !left.equals(right);
                    }
                }
                throw new UnsupportedOperationException("unhandled type: " + node.getType());
            }
            return new ComparisonExpression(node.getType(), LiteralInterpreter.toExpression(left), LiteralInterpreter.toExpression(right));
        }

        protected Object visitBetweenPredicate(BetweenPredicate node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            Object min = this.process((Node)node.getMin(), context);
            if (min == null) {
                return null;
            }
            Object max = this.process((Node)node.getMax(), context);
            if (max == null) {
                return null;
            }
            if (value instanceof Number && min instanceof Number && max instanceof Number) {
                return ((Number)min).doubleValue() <= ((Number)value).doubleValue() && ((Number)value).doubleValue() <= ((Number)max).doubleValue();
            }
            if (value instanceof Slice && min instanceof Slice && max instanceof Slice) {
                return ((Slice)min).compareTo((Slice)value) <= 0 && ((Slice)value).compareTo((Slice)max) <= 0;
            }
            return new BetweenPredicate(LiteralInterpreter.toExpression(value), LiteralInterpreter.toExpression(min), LiteralInterpreter.toExpression(max));
        }

        protected Object visitNullIfExpression(NullIfExpression node, Object context) {
            Object first = this.process((Node)node.getFirst(), context);
            if (first == null) {
                return null;
            }
            Object second = this.process((Node)node.getSecond(), context);
            if (second == null) {
                return first;
            }
            if (first instanceof Long && second instanceof Long) {
                return ((Long)first).longValue() == ((Long)second).longValue() ? null : first;
            }
            if (first instanceof Number && second instanceof Number) {
                return ((Number)first).doubleValue() == ((Number)second).doubleValue() ? null : first;
            }
            if (first instanceof Boolean && second instanceof Boolean) {
                return first.equals(second) ? null : first;
            }
            if (first instanceof Slice && second instanceof Slice) {
                return first.equals(second) ? null : first;
            }
            return node;
        }

        protected Object visitIfExpression(IfExpression node, Object context) {
            Object condition = this.process((Node)node.getCondition(), context);
            if (Boolean.TRUE.equals(condition)) {
                return this.process((Node)node.getTrueValue(), context);
            }
            if (condition == null || Boolean.FALSE.equals(condition)) {
                if (node.getFalseValue().isPresent()) {
                    return this.process((Node)node.getFalseValue().get(), context);
                }
                return null;
            }
            Object trueValue = this.optimize((Node)node.getTrueValue(), context);
            Object falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = this.optimize((Node)node.getFalseValue().get(), context);
            }
            return new IfExpression(LiteralInterpreter.toExpression(condition), LiteralInterpreter.toExpression(trueValue), LiteralInterpreter.toExpression(falseValue));
        }

        protected Object visitNotExpression(NotExpression node, Object context) {
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return node;
            }
            return (Boolean)value == false;
        }

        protected Object visitLogicalBinaryExpression(LogicalBinaryExpression node, Object context) {
            Object left = this.process((Node)node.getLeft(), context);
            Object right = this.process((Node)node.getRight(), context);
            switch (node.getType()) {
                case AND: {
                    if (Boolean.FALSE.equals(left) || Boolean.TRUE.equals(right)) {
                        return left;
                    }
                    if (Boolean.FALSE.equals(right) || Boolean.TRUE.equals(left)) {
                        return right;
                    }
                }
                case OR: {
                    if (Boolean.TRUE.equals(left) || Boolean.FALSE.equals(right)) {
                        return left;
                    }
                    if (!Boolean.TRUE.equals(right) && !Boolean.FALSE.equals(left)) break;
                    return right;
                }
            }
            if (left == null && right == null) {
                return null;
            }
            return node;
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Object context) {
            return node.equals((Object)BooleanLiteral.TRUE_LITERAL);
        }

        protected Object visitFunctionCall(FunctionCall node, Object context) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (Expression expression : node.getArguments()) {
                Type type;
                Object value = this.process((Node)expression, context);
                if (value == null) {
                    return null;
                }
                if (value instanceof Double) {
                    type = Type.DOUBLE;
                } else if (value instanceof Long) {
                    type = Type.BIGINT;
                } else if (value instanceof Slice) {
                    type = Type.VARCHAR;
                } else if (value instanceof Boolean) {
                    type = Type.BOOLEAN;
                } else {
                    if (value instanceof Expression) {
                        return node;
                    }
                    throw new UnsupportedOperationException("Unhandled value type: " + value.getClass().getName());
                }
                argumentValues.add(value);
                argumentTypes.add(type);
            }
            FunctionInfo function = ExpressionInterpreter.this.metadata.getFunction(node.getName(), argumentTypes);
            if (ExpressionInterpreter.this.optimize && !function.isDeterministic()) {
                return new FunctionCall(node.getName(), (Window)node.getWindow().orNull(), node.isDistinct(), LiteralInterpreter.toExpressions(argumentValues));
            }
            MethodHandle handle = function.getScalarFunction();
            if (handle.type().parameterCount() > 0 && handle.type().parameterType(0) == Session.class) {
                handle = handle.bindTo(ExpressionInterpreter.this.session);
            }
            try {
                return handle.invokeWithArguments(argumentValues);
            }
            catch (Throwable throwable) {
                Throwables.propagateIfInstanceOf((Throwable)throwable, RuntimeException.class);
                Throwables.propagateIfInstanceOf((Throwable)throwable, Error.class);
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
        }

        protected Object visitLikePredicate(LikePredicate node, Object context) {
            String stringPattern;
            Object value = this.process((Node)node.getValue(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Slice && node.getPattern() instanceof StringLiteral && (node.getEscape() instanceof StringLiteral || node.getEscape() == null)) {
                return LikeUtils.regexMatches(this.getConstantPattern(node), (Slice)value);
            }
            Object pattern = this.process((Node)node.getPattern(), context);
            if (pattern == null) {
                return null;
            }
            Object escape = null;
            if (node.getEscape() != null && (escape = this.process((Node)node.getEscape(), context)) == null) {
                return null;
            }
            if (value instanceof Slice && pattern instanceof Slice && (escape == null || escape instanceof Slice)) {
                Regex regex = LikeUtils.likeToPattern((Slice)pattern, (Slice)escape);
                return LikeUtils.regexMatches(regex, (Slice)value);
            }
            if (pattern instanceof Slice && escape == null && !(stringPattern = ((Slice)pattern).toString(Charsets.UTF_8)).contains("%") && !stringPattern.contains("_")) {
                return new ComparisonExpression(ComparisonExpression.Type.EQUAL, LiteralInterpreter.toExpression(value), LiteralInterpreter.toExpression(pattern));
            }
            Expression optimizedEscape = null;
            if (node.getEscape() != null) {
                optimizedEscape = LiteralInterpreter.toExpression(escape);
            }
            return new LikePredicate(LiteralInterpreter.toExpression(value), LiteralInterpreter.toExpression(pattern), optimizedEscape);
        }

        private Regex getConstantPattern(LikePredicate node) {
            Regex result = (Regex)ExpressionInterpreter.this.LIKE_PATTERN_CACHE.get(node);
            if (result == null) {
                StringLiteral pattern = (StringLiteral)node.getPattern();
                StringLiteral escape = (StringLiteral)node.getEscape();
                result = LikeUtils.likeToPattern(pattern.getSlice(), escape == null ? null : escape.getSlice());
                ExpressionInterpreter.this.LIKE_PATTERN_CACHE.put(node, result);
            }
            return result;
        }

        protected Object visitExtract(Extract node, Object context) {
            Object value = this.process((Node)node.getExpression(), context);
            if (value == null) {
                return null;
            }
            if (value instanceof Expression) {
                return new Extract(LiteralInterpreter.toExpression(value), node.getField());
            }
            long time = (Long)value;
            switch (node.getField()) {
                case CENTURY: {
                    return UnixTimeFunctions.century(time);
                }
                case YEAR: {
                    return UnixTimeFunctions.year(time);
                }
                case QUARTER: {
                    return UnixTimeFunctions.quarter(time);
                }
                case MONTH: {
                    return UnixTimeFunctions.month(time);
                }
                case WEEK: {
                    return UnixTimeFunctions.week(time);
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return UnixTimeFunctions.day(time);
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return UnixTimeFunctions.dayOfWeek(time);
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return UnixTimeFunctions.dayOfYear(time);
                }
                case HOUR: {
                    return UnixTimeFunctions.hour(time);
                }
                case MINUTE: {
                    return UnixTimeFunctions.minute(time);
                }
                case SECOND: {
                    return UnixTimeFunctions.second(time);
                }
                case TIMEZONE_HOUR: 
                case TIMEZONE_MINUTE: {
                    return 0L;
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }

        public Object visitCast(Cast node, Object context) {
            Object value = this.process((Node)node.getExpression(), context);
            if (value instanceof Expression) {
                return new Cast((Expression)value, node.getType());
            }
            if (value == null) {
                return null;
            }
            switch (node.getType()) {
                case "BOOLEAN": {
                    return Casts.toBoolean(value);
                }
                case "VARCHAR": {
                    return Casts.toSlice(value);
                }
                case "DOUBLE": {
                    return Casts.toDouble(value);
                }
                case "BIGINT": {
                    return Casts.toLong(value);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + node.getType());
        }

        protected Object visitExpression(Expression node, Object context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        protected Object visitNode(Node node, Object context) {
            throw new UnsupportedOperationException("Evaluator visitor can only handle Expression nodes");
        }

        private Object optimize(Node node, Object context) {
            Preconditions.checkState((boolean)ExpressionInterpreter.this.optimize, (Object)"not optimizing");
            try {
                return this.process(node, context);
            }
            catch (RuntimeException e) {
                return node;
            }
        }
    }
}

