/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class DomainUtils {
    private DomainUtils() {
    }

    public static <T> Map<Symbol, T> columnHandleToSymbol(Map<ColumnHandle, T> columnMap, Map<Symbol, ColumnHandle> assignments) {
        ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(assignments).inverse();
        Preconditions.checkArgument((boolean)inverseAssignments.keySet().containsAll(columnMap.keySet()), (Object)"assignments does not contain all required column handles");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, T> entry : columnMap.entrySet()) {
            builder.put(inverseAssignments.get(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public static Domain simplifyDomain(Domain domain) {
        if (domain.getRanges().getRangeCount() <= 32) {
            return domain;
        }
        return Domain.create((SortedRangeSet)SortedRangeSet.of((Range)domain.getRanges().getSpan(), (Range[])new Range[0]), (boolean)domain.isNullAllowed());
    }

    public static Function<Domain, Domain> simplifyDomainFunction() {
        return new Function<Domain, Domain>(){

            public Domain apply(Domain domain) {
                return DomainUtils.simplifyDomain(domain);
            }
        };
    }
}

