/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.math.DoubleMath;
import io.airlift.slice.Slice;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;

public final class DomainTranslator {
    private DomainTranslator() {
    }

    public static Expression toPredicate(TupleDomain tupleDomain, Map<ColumnHandle, Symbol> symbolTranslationMap) {
        if (tupleDomain.isNone()) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        ImmutableList.Builder conjunctBuilder = ImmutableList.builder();
        for (Map.Entry entry : tupleDomain.getDomains().entrySet()) {
            ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
            Preconditions.checkArgument((boolean)symbolTranslationMap.containsKey(columnHandle), (String)"Unable to convert TupleDomain to Expression b/c don't know Symbol for ColumnHandle %s", (Object[])new Object[]{columnHandle});
            QualifiedNameReference reference = new QualifiedNameReference(symbolTranslationMap.get(columnHandle).toQualifiedName());
            conjunctBuilder.add((Object)DomainTranslator.toPredicate((Domain)entry.getValue(), reference));
        }
        return ExpressionUtils.combineConjuncts((Iterable<Expression>)conjunctBuilder.build());
    }

    private static Expression toPredicate(Domain domain, QualifiedNameReference reference) {
        if (domain.getRanges().isNone()) {
            return domain.isNullAllowed() ? new IsNullPredicate((Expression)reference) : BooleanLiteral.FALSE_LITERAL;
        }
        if (domain.getRanges().isAll()) {
            return domain.isNullAllowed() ? BooleanLiteral.TRUE_LITERAL : new IsNotNullPredicate((Expression)reference);
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        for (Range range : domain.getRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(LiteralInterpreter.toExpression(range.getLow().getValue()));
                continue;
            }
            ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
            if (!range.getLow().isLowerUnbounded()) {
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue())));
                        break;
                    }
                    case EXACTLY: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue())));
                        break;
                    }
                    case BELOW: {
                        throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                    }
                }
            }
            if (!range.getHigh().isUpperUnbounded()) {
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                    }
                    case EXACTLY: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue())));
                        break;
                    }
                    case BELOW: {
                        rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue())));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                    }
                }
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add(ExpressionUtils.combineConjuncts(rangeConjuncts));
        }
        if (singleValues.size() == 1) {
            disjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(singleValues)));
        }
        Preconditions.checkState((!disjuncts.isEmpty() ? 1 : 0) != 0);
        if (domain.isNullAllowed()) {
            disjuncts.add((Expression)new IsNullPredicate((Expression)reference));
        }
        return ExpressionUtils.combineDisjunctsWithDefault(disjuncts, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    public static ExtractionResult fromPredicate(Expression predicate, Map<Symbol, Type> types, Map<Symbol, ColumnHandle> columnHandleTranslationMap) {
        return (ExtractionResult)new Visitor(types, columnHandleTranslationMap).process((Node)predicate, false);
    }

    private static boolean isSimpleComparison(ComparisonExpression comparison) {
        return comparison.getLeft() instanceof QualifiedNameReference && comparison.getRight() instanceof Literal || comparison.getLeft() instanceof Literal && comparison.getRight() instanceof QualifiedNameReference;
    }

    private static ComparisonExpression normalizeSimpleComparison(ComparisonExpression comparison) {
        if (comparison.getLeft() instanceof QualifiedNameReference && comparison.getRight() instanceof Literal) {
            return comparison;
        }
        if (comparison.getLeft() instanceof Literal && comparison.getRight() instanceof QualifiedNameReference) {
            return new ComparisonExpression(DomainTranslator.flipComparisonDirection(comparison.getType()), comparison.getRight(), comparison.getLeft());
        }
        throw new IllegalArgumentException("ComparisonExpression not a simple literal comparison: " + comparison);
    }

    private static ComparisonExpression.Type flipComparisonDirection(ComparisonExpression.Type type) {
        switch (type) {
            case LESS_THAN_OR_EQUAL: {
                return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return ComparisonExpression.Type.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return ComparisonExpression.Type.LESS_THAN;
            }
        }
        return type;
    }

    private static Expression coerceDoubleToLongComparison(ComparisonExpression comparison) {
        comparison = DomainTranslator.normalizeSimpleComparison(comparison);
        Preconditions.checkArgument((boolean)(comparison.getLeft() instanceof QualifiedNameReference), (Object)"Left must be a QualifiedNameReference");
        Preconditions.checkArgument((boolean)(comparison.getRight() instanceof DoubleLiteral), (Object)"Right must be a DoubleLiteral");
        QualifiedNameReference reference = (QualifiedNameReference)comparison.getLeft();
        Double value = ((DoubleLiteral)comparison.getRight()).getValue();
        switch (comparison.getType()) {
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: {
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.CEILING)));
            }
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR)));
            }
            case EQUAL: {
                Long equalValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (equalValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(equalValue));
            }
            case NOT_EQUAL: {
                Long notEqualValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (notEqualValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(notEqualValue));
            }
            case IS_DISTINCT_FROM: {
                Long distinctValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (distinctValue.doubleValue() != value.doubleValue()) {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                return new ComparisonExpression(comparison.getType(), (Expression)reference, LiteralInterpreter.toExpression(distinctValue));
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + comparison.getType()));
    }

    public static class ExtractionResult {
        private final TupleDomain tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain tupleDomain, Expression remainingExpression) {
            this.tupleDomain = (TupleDomain)Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
            this.remainingExpression = (Expression)Preconditions.checkNotNull((Object)remainingExpression, (Object)"remainingExpression is null");
        }

        public TupleDomain getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class Visitor
    extends AstVisitor<ExtractionResult, Boolean> {
        private final Map<Symbol, Type> types;
        private final Map<Symbol, ColumnHandle> columnHandles;

        private Visitor(Map<Symbol, Type> types, Map<Symbol, ColumnHandle> columnHandles) {
            this.types = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.columnHandles = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(columnHandles, (Object)"columnHandles is null")));
        }

        private ColumnType checkedTypeLookup(Symbol symbol) {
            Type type = this.types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Types is missing info for symbol: %s", (Object[])new Object[]{symbol});
            return type.getColumnType();
        }

        private ColumnHandle checkedColumnHandleLookup(Symbol symbol) {
            ColumnHandle columnHandle = this.columnHandles.get(symbol);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"ColumnHandles is missing info for symbol: %s", (Object[])new Object[]{symbol});
            return columnHandle;
        }

        private static SortedRangeSet complementIfNecessary(SortedRangeSet range, boolean complement) {
            return complement ? range.complement() : range;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new NotExpression(expression) : expression;
        }

        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult(TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        protected ExtractionResult visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean complement) {
            ExtractionResult leftResult = (ExtractionResult)this.process((Node)node.getLeft(), complement);
            ExtractionResult rightResult = (ExtractionResult)this.process((Node)node.getRight(), complement);
            LogicalBinaryExpression.Type type = complement != false ? Visitor.flipLogicalBinaryType(node.getType()) : node.getType();
            switch (type) {
                case AND: {
                    return new ExtractionResult(leftResult.getTupleDomain().intersect(rightResult.getTupleDomain()), ExpressionUtils.combineConjuncts(leftResult.getRemainingExpression(), rightResult.getRemainingExpression()));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = leftResult.getTupleDomain().columnWiseUnion(rightResult.getTupleDomain());
                    Expression remainingExpression = Visitor.complementIfNecessary((Expression)node, (boolean)complement);
                    if (leftResult.getRemainingExpression().equals((Object)rightResult.getRemainingExpression()) && DeterminismEvaluator.isDeterministic(leftResult.getRemainingExpression())) {
                        boolean oneSideIsSuperSet;
                        boolean matchingSingleSymbolDomains = !leftResult.getTupleDomain().isNone() && !rightResult.getTupleDomain().isNone() && leftResult.getTupleDomain().getDomains().size() == 1 && rightResult.getTupleDomain().getDomains().size() == 1 && leftResult.getTupleDomain().getDomains().keySet().equals(rightResult.getTupleDomain().getDomains().keySet());
                        boolean bl = oneSideIsSuperSet = leftResult.getTupleDomain().contains(rightResult.getTupleDomain()) || rightResult.getTupleDomain().contains(leftResult.getTupleDomain());
                        if (matchingSingleSymbolDomains || oneSideIsSuperSet) {
                            remainingExpression = leftResult.getRemainingExpression();
                        }
                    }
                    return new ExtractionResult(columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown type: " + node.getType()));
        }

        private static LogicalBinaryExpression.Type flipLogicalBinaryType(LogicalBinaryExpression.Type type) {
            switch (type) {
                case AND: {
                    return LogicalBinaryExpression.Type.OR;
                }
                case OR: {
                    return LogicalBinaryExpression.Type.AND;
                }
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }

        protected ExtractionResult visitNotExpression(NotExpression node, Boolean complement) {
            return (ExtractionResult)this.process((Node)node.getValue(), complement == false);
        }

        protected ExtractionResult visitComparisonExpression(ComparisonExpression node, Boolean complement) {
            if (!DomainTranslator.isSimpleComparison(node)) {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            node = DomainTranslator.normalizeSimpleComparison(node);
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getLeft()).getName());
            ColumnType columnType = this.checkedTypeLookup(symbol);
            ColumnHandle columnHandle = this.checkedColumnHandleLookup(symbol);
            Object value = LiteralInterpreter.evaluate(node.getRight());
            if (value instanceof Double && columnType == ColumnType.LONG) {
                return (ExtractionResult)this.process((Node)DomainTranslator.coerceDoubleToLongComparison(node), complement);
            }
            if (value instanceof Long && columnType == ColumnType.DOUBLE) {
                value = ((Long)value).doubleValue();
            }
            if (value instanceof Slice) {
                value = ((Slice)value).toStringUtf8();
            }
            Visitor.verifyType(columnType, value);
            return this.createComparisonExtractionResult(node.getType(), columnHandle, columnType, Visitor.objectToComparable(value), complement);
        }

        private ExtractionResult createComparisonExtractionResult(ComparisonExpression.Type comparisonType, ColumnHandle columnHandle, ColumnType columnType, Comparable<?> value, boolean complement) {
            Domain domain;
            if (value == null) {
                switch (comparisonType) {
                    case EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case NOT_EQUAL: {
                        return new ExtractionResult(TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                    case IS_DISTINCT_FROM: {
                        Domain domain2 = Visitor.complementIfNecessary(Domain.notNull((Class)columnType.getNativeType()), complement);
                        return new ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                }
                throw new AssertionError((Object)("Unhandled type: " + comparisonType));
            }
            switch (comparisonType) {
                case EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.equal(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case GREATER_THAN: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.greaterThan(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.greaterThanOrEqual(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case LESS_THAN: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThanOrEqual(value), (Range[])new Range[0]), complement), (boolean)false);
                    break;
                }
                case NOT_EQUAL: {
                    domain = Domain.create((SortedRangeSet)Visitor.complementIfNecessary(SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[]{Range.greaterThan(value)}), complement), (boolean)false);
                    break;
                }
                case IS_DISTINCT_FROM: {
                    domain = Visitor.complementIfNecessary(Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThan(value), (Range[])new Range[]{Range.greaterThan(value)}), (boolean)true), complement);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled type: " + comparisonType));
                }
            }
            return new ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private static void verifyType(ColumnType type, Object value) {
            Preconditions.checkState((value == null || type.getNativeType().isInstance(value) ? 1 : 0) != 0, (String)"Value %s is not of expected type %s", (Object[])new Object[]{value, type});
        }

        private static Comparable<?> objectToComparable(Object value) {
            return (Comparable)value;
        }

        protected ExtractionResult visitInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference) || !(node.getValueList() instanceof InListExpression)) {
                return (ExtractionResult)super.visitInPredicate(node, (Object)complement);
            }
            InListExpression valueList = (InListExpression)node.getValueList();
            Preconditions.checkState((!valueList.getValues().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : valueList.getValues()) {
                disjuncts.add((Object)new ComparisonExpression(ComparisonExpression.Type.EQUAL, node.getValue(), expression));
            }
            return (ExtractionResult)this.process((Node)ExpressionUtils.or((Iterable<Expression>)disjuncts.build()), complement);
        }

        protected ExtractionResult visitBetweenPredicate(BetweenPredicate node, Boolean complement) {
            return (ExtractionResult)this.process((Node)ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax())}), complement);
        }

        protected ExtractionResult visitIsNullPredicate(IsNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            ColumnType columnType = this.checkedTypeLookup(symbol);
            ColumnHandle columnHandle = this.checkedColumnHandleLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Class)columnType.getNativeType()), (boolean)complement);
            return new ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitIsNotNullPredicate(IsNotNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNotNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            ColumnType columnType = this.checkedTypeLookup(symbol);
            ColumnHandle columnHandle = this.checkedColumnHandleLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.notNull((Class)columnType.getNativeType()), (boolean)complement);
            return new ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitBooleanLiteral(BooleanLiteral node, Boolean complement) {
            boolean value = complement.booleanValue() ? !node.getValue() : node.getValue();
            return new ExtractionResult(value ? TupleDomain.all() : TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitNullLiteral(NullLiteral node, Boolean complement) {
            return new ExtractionResult(TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
    }
}

