/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.DataSource;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.planner.MaterializedViewWriter;
import com.facebook.presto.sql.planner.OutputReceiver;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.StageExecutionPlan;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MaterializedViewWriterNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DistributedExecutionPlanner {
    private final SplitManager splitManager;
    private final ShardManager shardManager;

    @Inject
    public DistributedExecutionPlanner(SplitManager splitManager, ShardManager shardManager) {
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"databaseShardManager is null");
    }

    public StageExecutionPlan plan(SubPlan root) {
        return this.plan(root, (Predicate<Partition>)Predicates.alwaysTrue());
    }

    public StageExecutionPlan plan(SubPlan root, Predicate<Partition> materializedViewPartitionPredicate) {
        PlanFragment currentFragment = root.getFragment();
        Visitor visitor = new Visitor();
        NodeSplits nodeSplits = currentFragment.getRoot().accept(visitor, materializedViewPartitionPredicate);
        ImmutableList.Builder dependencies = ImmutableList.builder();
        for (SubPlan childPlan : root.getChildren()) {
            dependencies.add((Object)this.plan(childPlan, materializedViewPartitionPredicate));
        }
        return new StageExecutionPlan(currentFragment, (Optional<DataSource>)nodeSplits.dataSource, (List<StageExecutionPlan>)dependencies.build(), visitor.getOutputReceivers());
    }

    private class NodeSplits {
        private final PlanNodeId planNodeId;
        private final Optional<DataSource> dataSource;

        private NodeSplits(PlanNodeId planNodeId) {
            this.planNodeId = planNodeId;
            this.dataSource = Optional.absent();
        }

        private NodeSplits(PlanNodeId planNodeId, DataSource dataSource) {
            this.planNodeId = planNodeId;
            this.dataSource = Optional.of((Object)dataSource);
        }
    }

    private final class Visitor
    extends PlanVisitor<Predicate<Partition>, NodeSplits> {
        private final Map<PlanNodeId, OutputReceiver> outputReceivers = new HashMap<PlanNodeId, OutputReceiver>();

        private Visitor() {
        }

        public Map<PlanNodeId, OutputReceiver> getOutputReceivers() {
            return ImmutableMap.copyOf(this.outputReceivers);
        }

        @Override
        public NodeSplits visitTableScan(TableScanNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            ImmutableList partitions = FluentIterable.from(this.getPartitions(node)).filter(materializedViewPartitionPredicate).toList();
            DataSource dataSource = DistributedExecutionPlanner.this.splitManager.getPartitionSplits(node.getTable(), (List<Partition>)partitions);
            return new NodeSplits(node.getId(), dataSource);
        }

        private List<Partition> getPartitions(TableScanNode node) {
            if (node.getGeneratedPartitions().isPresent()) {
                return ((TableScanNode.GeneratedPartitions)node.getGeneratedPartitions().get()).getPartitions();
            }
            PartitionResult allPartitions = DistributedExecutionPlanner.this.splitManager.getPartitions(node.getTable(), (Optional<TupleDomain>)Optional.absent());
            return allPartitions.getPartitions();
        }

        @Override
        public NodeSplits visitJoin(JoinNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            NodeSplits leftSplits = node.getLeft().accept(this, materializedViewPartitionPredicate);
            NodeSplits rightSplits = node.getRight().accept(this, materializedViewPartitionPredicate);
            if (leftSplits.dataSource.isPresent() && rightSplits.dataSource.isPresent()) {
                throw new IllegalArgumentException("Both left and right join nodes are partitioned");
            }
            return leftSplits.dataSource.isPresent() ? leftSplits : rightSplits;
        }

        @Override
        public NodeSplits visitSemiJoin(SemiJoinNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            NodeSplits sourceSplits = node.getSource().accept(this, materializedViewPartitionPredicate);
            NodeSplits filteringSourceSplits = node.getFilteringSource().accept(this, materializedViewPartitionPredicate);
            if (sourceSplits.dataSource.isPresent() && filteringSourceSplits.dataSource.isPresent()) {
                throw new IllegalArgumentException("Both source and filteringSource semi join nodes are partitioned");
            }
            return sourceSplits.dataSource.isPresent() ? sourceSplits : filteringSourceSplits;
        }

        @Override
        public NodeSplits visitExchange(ExchangeNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return new NodeSplits(node.getId());
        }

        @Override
        public NodeSplits visitFilter(FilterNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitSample(SampleNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            switch (node.getSampleType()) {
                case BERNOULLI: {
                    return node.getSource().accept(this, materializedViewPartitionPredicate);
                }
                case SYSTEM: {
                    NodeSplits nodeSplits = node.getSource().accept(this, materializedViewPartitionPredicate);
                    if (nodeSplits.dataSource.isPresent()) {
                        DataSource dataSource = (DataSource)nodeSplits.dataSource.get();
                        final double ratio = node.getSampleRatio();
                        Iterable sampleIterable = Iterables.filter(dataSource.getSplits(), (Predicate)new Predicate<Split>(){

                            public boolean apply(@Nullable Split input) {
                                return ThreadLocalRandom.current().nextDouble() < ratio;
                            }
                        });
                        DataSource sampledDataSource = new DataSource(dataSource.getDataSourceName(), sampleIterable);
                        return new NodeSplits(node.getId(), sampledDataSource);
                    }
                    return nodeSplits;
                }
            }
            throw new UnsupportedOperationException("Sampling is not supported for type " + (Object)((Object)node.getSampleType()));
        }

        @Override
        public NodeSplits visitAggregation(AggregationNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitWindow(WindowNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitProject(ProjectNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitTopN(TopNNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitOutput(OutputNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitLimit(LimitNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitSort(SortNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitSink(SinkNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            return node.getSource().accept(this, materializedViewPartitionPredicate);
        }

        @Override
        public NodeSplits visitMaterializedViewWriter(MaterializedViewWriterNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            MaterializedViewWriter materializedViewWriter = new MaterializedViewWriter(node, DistributedExecutionPlanner.this.shardManager);
            NodeSplits nodeSplits = node.getSource().accept(this, materializedViewWriter.getPartitionPredicate());
            Preconditions.checkState((boolean)nodeSplits.dataSource.isPresent(), (Object)"No splits present for import");
            DataSource dataSource = (DataSource)nodeSplits.dataSource.get();
            this.outputReceivers.put(node.getId(), materializedViewWriter.getOutputReceiver());
            Iterable<Split> newSplits = materializedViewWriter.wrapSplits(nodeSplits.planNodeId, dataSource.getSplits());
            return new NodeSplits(node.getId(), new DataSource(dataSource.getDataSourceName(), newSplits));
        }

        @Override
        protected NodeSplits visitPlan(PlanNode node, Predicate<Partition> materializedViewPartitionPredicate) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }
}

