/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.sql.planner.LikeUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import org.joni.Regex;

public class LikeFunctionBinder
implements FunctionBinder {
    private static final MethodHandle constantPattern;
    private static final MethodHandle dynamicPattern;

    @Override
    public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments) {
        MethodHandle methodHandle;
        TypedByteCodeNode valueNode = arguments.get(0);
        TypedByteCodeNode patternNode = arguments.get(1);
        TypedByteCodeNode escapeNode = null;
        if (arguments.size() == 3) {
            escapeNode = arguments.get(2);
        }
        if (patternNode.getNode() instanceof Constant && (escapeNode == null || escapeNode.getNode() instanceof Constant)) {
            Slice pattern = (Slice)((Constant)patternNode.getNode()).getValue();
            Slice escapeSlice = null;
            if (escapeNode != null) {
                escapeSlice = (Slice)((Constant)escapeNode.getNode()).getValue();
            }
            Regex regex = LikeUtils.likeToPattern(pattern, escapeSlice);
            methodHandle = constantPattern.bindTo(regex);
            arguments = ImmutableList.of((Object)valueNode);
        } else {
            methodHandle = dynamicPattern.bindTo(new LikeUtils.LikePatternCache(100));
            if (escapeNode == null) {
                methodHandle = MethodHandles.insertArguments(methodHandle, 2, new Object[]{null});
            }
        }
        ConstantCallSite callSite = new ConstantCallSite(methodHandle);
        return new FunctionBinding(bindingId, name, callSite, (List<TypedByteCodeNode>)arguments, false);
    }

    static {
        try {
            constantPattern = MethodHandles.lookup().findStatic(LikeUtils.class, "regexMatches", MethodType.methodType(Boolean.TYPE, Regex.class, Slice.class));
            dynamicPattern = MethodHandles.lookup().findStatic(LikeUtils.class, "dynamicLike", MethodType.methodType(Boolean.TYPE, LikeUtils.LikePatternCache.class, Slice.class, Slice.class, Slice.class));
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

