/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.planner.DistributedLogicalPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanPrinter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.storage.StorageManager;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public class QueryExplainer {
    public final Session session;
    public final List<PlanOptimizer> planOptimizers;
    public final Metadata metadata;
    public final PeriodicImportManager periodicImportManager;
    public final StorageManager storageManager;

    public QueryExplainer(Session session, List<PlanOptimizer> planOptimizers, Metadata metadata, PeriodicImportManager periodicImportManager, StorageManager storageManager) {
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.planOptimizers = (List)Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.periodicImportManager = (PeriodicImportManager)Preconditions.checkNotNull((Object)periodicImportManager, (Object)"periodicImportManager is null");
        this.storageManager = (StorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
    }

    public String getPlan(Query query, ExplainType.Type planType) {
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(query);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(query);
                return PlanPrinter.textDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getGraphvizPlan(Query query, ExplainType.Type planType) {
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(query);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(query);
                return PlanPrinter.graphvizDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private Plan getLogicalPlan(Query query) {
        Analyzer analyzer = new Analyzer(this.session, this.metadata, (Optional<QueryExplainer>)Optional.of((Object)this));
        Analysis analysis = analyzer.analyze((Statement)query);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.session, this.planOptimizers, idAllocator, this.metadata, this.periodicImportManager, this.storageManager);
        return logicalPlanner.plan(analysis);
    }

    private SubPlan getDistributedPlan(Query query) {
        Analyzer analyzer = new Analyzer(this.session, this.metadata, (Optional<QueryExplainer>)Optional.of((Object)this));
        Analysis analysis = analyzer.analyze((Statement)query);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.session, this.planOptimizers, idAllocator, this.metadata, this.periodicImportManager, this.storageManager);
        Plan plan = logicalPlanner.plan(analysis);
        return new DistributedLogicalPlanner(this.metadata, idAllocator).createSubPlans(plan, false);
    }
}

