/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionKey;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.split.NativeSplitManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Map;

public class PartitionFunction
implements Function<TablePartition, Partition> {
    private final Map<String, ColumnHandle> columnHandles;
    private final Multimap<String, ? extends PartitionKey> allPartitionKeys;

    PartitionFunction(Map<String, ColumnHandle> columnHandles, Multimap<String, ? extends PartitionKey> allPartitionKeys) {
        this.columnHandles = (Map)Preconditions.checkNotNull(columnHandles, (Object)"columnHandles is null");
        this.allPartitionKeys = (Multimap)Preconditions.checkNotNull(allPartitionKeys, (Object)"allPartitionKeys is null");
    }

    public Partition apply(TablePartition tablePartition) {
        String partitionName = tablePartition.getPartitionName();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PartitionKey partitionKey : this.allPartitionKeys.get((Object)partitionName)) {
            ColumnHandle columnHandle = this.columnHandles.get(partitionKey.getName());
            Preconditions.checkArgument((this.columnHandles != null ? 1 : 0) != 0, (String)"Invalid partition key for column %s in partition %s", (Object[])new Object[]{partitionKey.getName(), tablePartition.getPartitionName()});
            String value = partitionKey.getValue();
            switch (partitionKey.getType()) {
                case BOOLEAN: {
                    if (value.length() == 0) {
                        builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Boolean.valueOf(false)));
                        break;
                    }
                    builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Boolean.valueOf(Boolean.parseBoolean(value))));
                    break;
                }
                case LONG: {
                    if (value.length() == 0) {
                        builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Long.valueOf(0L)));
                        break;
                    }
                    builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Long.valueOf(Long.parseLong(value))));
                    break;
                }
                case DOUBLE: {
                    if (value.length() == 0) {
                        builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Double.valueOf(0.0)));
                        break;
                    }
                    builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)Double.valueOf(Double.parseDouble(value))));
                    break;
                }
                case STRING: {
                    builder.put((Object)columnHandle, (Object)Domain.singleValue((Comparable)((Object)value)));
                }
            }
        }
        return new NativeSplitManager.NativePartition(tablePartition.getPartitionId(), TupleDomain.withColumnDomains((Map)builder.build()));
    }
}

