/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NativeTableHandle;
import com.facebook.presto.metadata.Node;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.TablePartition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.PartitionKey;
import com.facebook.presto.spi.PartitionResult;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.split.NativeSplit;
import com.facebook.presto.split.PartitionFunction;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class NativeSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(NativeSplitManager.class);
    private final NodeManager nodeManager;
    private final ShardManager shardManager;
    private final Metadata metadata;

    @Inject
    public NativeSplitManager(NodeManager nodeManager, ShardManager shardManager, Metadata metadata) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.shardManager = (ShardManager)Preconditions.checkNotNull((Object)shardManager, (Object)"shardManager is null");
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
    }

    public String getConnectorId() {
        return "native";
    }

    public boolean canHandle(TableHandle handle) {
        return handle instanceof NativeTableHandle;
    }

    public PartitionResult getPartitions(TableHandle tableHandle, TupleDomain tupleDomain) {
        Stopwatch partitionTimer = new Stopwatch();
        partitionTimer.start();
        Preconditions.checkArgument((boolean)(tableHandle instanceof NativeTableHandle), (Object)"Table must be a native table");
        TableMetadata tableMetadata = this.metadata.getTableMetadata(tableHandle);
        Preconditions.checkState((tableMetadata != null ? 1 : 0) != 0, (String)"no metadata for %s found", (Object[])new Object[]{tableHandle});
        Set<TablePartition> tablePartitions = this.shardManager.getPartitions(tableHandle);
        log.debug("Partition retrieval, native table %s (%d partitions): %dms", new Object[]{tableHandle, tablePartitions.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        Multimap<String, ? extends PartitionKey> allPartitionKeys = this.shardManager.getAllPartitionKeys(tableHandle);
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(tableHandle);
        log.debug("Partition key retrieval, native table %s (%d keys): %dms", new Object[]{tableHandle, allPartitionKeys.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        ImmutableList partitions = ImmutableList.copyOf((Collection)Collections2.transform(tablePartitions, (Function)new PartitionFunction(columnHandles, allPartitionKeys)));
        log.debug("Partition generation, native table %s (%d partitions): %dms", new Object[]{tableHandle, partitions.size(), partitionTimer.elapsed(TimeUnit.MILLISECONDS)});
        return new PartitionResult((List)partitions, tupleDomain);
    }

    public Iterable<Split> getPartitionSplits(TableHandle tableHandle, List<Partition> partitions) {
        Stopwatch splitTimer = new Stopwatch();
        splitTimer.start();
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableMap nodesById = Maps.uniqueIndex(this.nodeManager.getAllNodes().getActiveNodes(), Node.getIdentifierFunction());
        ArrayList<NativeSplit> splits = new ArrayList<NativeSplit>();
        Multimap<Long, Map.Entry<UUID, String>> partitionShardNodes = this.shardManager.getShardNodesByPartition(tableHandle);
        for (Partition partition : partitions) {
            Preconditions.checkArgument((boolean)(partition instanceof NativePartition), (Object)"Partition must be a native partition");
            NativePartition nativePartition = (NativePartition)partition;
            ImmutableMultimap.Builder shardNodes = ImmutableMultimap.builder();
            for (Map.Entry shardNode : partitionShardNodes.get((Object)nativePartition.getNativePartitionId())) {
                shardNodes.put(shardNode.getKey(), shardNode.getValue());
            }
            for (Map.Entry entry : shardNodes.build().asMap().entrySet()) {
                List<HostAddress> addresses = NativeSplitManager.getAddressesForNodes((Map<String, Node>)nodesById, (Iterable)entry.getValue());
                Preconditions.checkState((addresses.size() > 0 ? 1 : 0) != 0, (String)"no host for shard %s found", (Object[])new Object[]{entry.getKey()});
                NativeSplit split = new NativeSplit((UUID)entry.getKey(), addresses);
                splits.add(split);
            }
        }
        log.debug("Split retrieval for %d partitions (%d splits): %dms", new Object[]{partitions.size(), splits.size(), splitTimer.elapsed(TimeUnit.MILLISECONDS)});
        Collections.shuffle(splits);
        return ImmutableList.copyOf(splits);
    }

    private static List<HostAddress> getAddressesForNodes(Map<String, Node> nodeMap, Iterable<String> nodeIdentifiers) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.transform(nodeIdentifiers, (Function)Functions.forMap(nodeMap)), Node.hostAndPortGetter()));
    }

    public static class NativePartition
    implements Partition {
        private final long partitionId;
        private final TupleDomain tupleDomain;

        public NativePartition(long partitionId, TupleDomain tupleDomain) {
            this.partitionId = partitionId;
            this.tupleDomain = (TupleDomain)Preconditions.checkNotNull((Object)tupleDomain, (Object)"tupleDomain is null");
        }

        public String getPartitionId() {
            return Long.toString(this.partitionId);
        }

        public long getNativePartitionId() {
            return this.partitionId;
        }

        public TupleDomain getTupleDomain() {
            return this.tupleDomain;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.partitionId, this.tupleDomain});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NativePartition other = (NativePartition)obj;
            return this.partitionId == other.partitionId && Objects.equal((Object)this.tupleDomain, (Object)other.tupleDomain);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("tupleDomain", (Object)this.tupleDomain).toString();
        }
    }
}

