/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;

public class NativeSplit
implements Split {
    private final UUID shardUuid;
    private final List<HostAddress> addresses;

    @JsonCreator
    public NativeSplit(@JsonProperty(value="shardUuid") UUID shardUuid, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.shardUuid = (UUID)Preconditions.checkNotNull((Object)shardUuid, (Object)"shardUuid is null");
        Preconditions.checkNotNull(addresses, (Object)"addresses is null");
        this.addresses = ImmutableList.copyOf(addresses);
    }

    @JsonProperty
    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public UUID getShardUuid() {
        return this.shardUuid;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("shardUuid", (Object)this.shardUuid).add("hosts", this.addresses).toString();
    }
}

