/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.PartitionKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class NativePartitionKey
implements PartitionKey {
    private final String partitionName;
    private final String name;
    private final ColumnType type;
    private final String value;

    @JsonCreator
    public NativePartitionKey(@JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="name") String name, @JsonProperty(value="type") ColumnType type, @JsonProperty(value="value") String value) {
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.partitionName = partitionName;
        this.name = name;
        this.type = type;
        this.value = value;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public ColumnType getType() {
        return this.type;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("partitionName", (Object)this.partitionName).add("name", (Object)this.name).add("type", (Object)this.type).add("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionName, this.name, this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NativePartitionKey other = (NativePartitionKey)obj;
        return Objects.equal((Object)this.partitionName, (Object)other.partitionName) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public static Predicate<NativePartitionKey> partitionNamePredicate(final String partitionName) {
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        return new Predicate<NativePartitionKey>(){

            public boolean apply(NativePartitionKey input) {
                return partitionName.equals(input.getPartitionName());
            }
        };
    }

    public static class Mapper
    implements ResultSetMapper<NativePartitionKey> {
        public NativePartitionKey map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new NativePartitionKey(r.getString("partition_name"), r.getString("key_name"), ColumnType.valueOf((String)r.getString("key_type")), r.getString("key_value"));
        }
    }
}

