/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.DataStreamProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class DataStreamManager
implements DataStreamProvider {
    private final Set<ConnectorDataStreamProvider> dataStreamProviders = Sets.newSetFromMap(new ConcurrentHashMap());

    public DataStreamManager(ConnectorDataStreamProvider ... dataStreamProviders) {
        this((Set<ConnectorDataStreamProvider>)ImmutableSet.copyOf((Object[])dataStreamProviders));
    }

    @Inject
    public DataStreamManager(Set<ConnectorDataStreamProvider> dataStreamProviders) {
        this.dataStreamProviders.addAll(dataStreamProviders);
    }

    public void addConnectorDataStreamProvider(ConnectorDataStreamProvider connectorDataStreamProvider) {
        this.dataStreamProviders.add(connectorDataStreamProvider);
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, Split split, List<ColumnHandle> columns) {
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"no columns specified");
        return this.getDataStreamProvider(split).createNewDataStream(operatorContext, split, columns);
    }

    private ConnectorDataStreamProvider getDataStreamProvider(Split split) {
        for (ConnectorDataStreamProvider dataStreamProvider : this.dataStreamProviders) {
            if (!dataStreamProvider.canHandle(split)) continue;
            return dataStreamProvider;
        }
        throw new IllegalArgumentException("No data stream provider for " + split);
    }
}

