/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.dictionary.Dictionary;
import com.facebook.presto.block.uncompressed.UncompressedTupleInfoSerde;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public final class DictionarySerde {
    private DictionarySerde() {
    }

    public static int writeDictionary(SliceOutput sliceOutput, Dictionary dictionary) {
        int bytesWritten = UncompressedTupleInfoSerde.serialize(dictionary.getTupleInfo(), sliceOutput);
        sliceOutput.writeInt(dictionary.size());
        bytesWritten += 4;
        for (int index = 0; index < dictionary.size(); ++index) {
            Slice slice = dictionary.getTupleSlice(index);
            sliceOutput.writeBytes(slice);
            bytesWritten += slice.length();
        }
        return bytesWritten;
    }

    public static Dictionary readDictionary(Slice slice) {
        BasicSliceInput sliceInput = slice.getInput();
        return DictionarySerde.readDictionary((SliceInput)sliceInput);
    }

    public static Dictionary readDictionary(SliceInput sliceInput) {
        TupleInfo tupleInfo = UncompressedTupleInfoSerde.deserialize(sliceInput);
        int dictionarySize = sliceInput.readInt();
        Preconditions.checkArgument((dictionarySize >= 0 ? 1 : 0) != 0);
        Slice[] dictionary = new Slice[dictionarySize];
        for (int i = 0; i < dictionarySize; ++i) {
            dictionary[i] = tupleInfo.extractTupleSlice(sliceInput);
        }
        return new Dictionary(tupleInfo, dictionary);
    }
}

