/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.dictionary.Dictionary;
import com.facebook.presto.block.dictionary.DictionaryEncodedBlock;
import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.BlockEncodings;
import com.facebook.presto.serde.DictionarySerde;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class DictionaryBlockEncoding
implements BlockEncoding {
    private final Dictionary dictionary;
    private final BlockEncoding idBlockEncoding;

    public DictionaryBlockEncoding(Dictionary dictionary, BlockEncoding idBlockEncoding) {
        this.dictionary = (Dictionary)Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        this.idBlockEncoding = (BlockEncoding)Preconditions.checkNotNull((Object)idBlockEncoding, (Object)"idBlockEncoding is null");
    }

    public DictionaryBlockEncoding(SliceInput input) {
        this.dictionary = DictionarySerde.readDictionary(input);
        this.idBlockEncoding = BlockEncodings.readBlockEncoding(input);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public BlockEncoding getIdBlockEncoding() {
        return this.idBlockEncoding;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.dictionary.getTupleInfo();
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        DictionaryEncodedBlock dictionaryBlock = (DictionaryEncodedBlock)block;
        Preconditions.checkArgument((dictionaryBlock.getDictionary() == this.dictionary ? 1 : 0) != 0, (Object)"Block dictionary is not the same a this dictionary");
        this.idBlockEncoding.writeBlock(sliceOutput, dictionaryBlock.getIdBlock());
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block idBlock = this.idBlockEncoding.readBlock(sliceInput);
        return new DictionaryEncodedBlock(this.dictionary, idBlock);
    }

    public static void serialize(SliceOutput output, DictionaryBlockEncoding encoding) {
        DictionarySerde.writeDictionary(output, encoding.dictionary);
        BlockEncodings.writeBlockEncoding(output, encoding.idBlockEncoding);
    }
}

