/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.BlockEncoding;
import com.facebook.presto.serde.DictionaryBlockEncoding;
import com.facebook.presto.serde.RunLengthBlockEncoding;
import com.facebook.presto.serde.SnappyBlockEncoding;
import com.facebook.presto.serde.UncompressedBlockEncoding;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class BlockEncodings {
    public static BlockEncoding readBlockEncoding(SliceInput input) {
        byte encoding = input.readByte();
        switch (encoding) {
            case 0: {
                return new UncompressedBlockEncoding(input);
            }
            case 1: {
                return new RunLengthBlockEncoding(input);
            }
            case 2: {
                return new DictionaryBlockEncoding(input);
            }
            case 3: {
                return new SnappyBlockEncoding(input);
            }
        }
        throw new IllegalArgumentException("unknown encoding " + encoding);
    }

    public static void writeBlockEncoding(SliceOutput output, BlockEncoding encoding) {
        if (encoding instanceof UncompressedBlockEncoding) {
            output.writeByte(0);
            UncompressedBlockEncoding.serialize(output, (UncompressedBlockEncoding)encoding);
        } else if (encoding instanceof RunLengthBlockEncoding) {
            output.writeByte(1);
            RunLengthBlockEncoding.serialize(output, (RunLengthBlockEncoding)encoding);
        } else if (encoding instanceof DictionaryBlockEncoding) {
            output.writeByte(2);
            DictionaryBlockEncoding.serialize(output, (DictionaryBlockEncoding)encoding);
        } else if (encoding instanceof SnappyBlockEncoding) {
            output.writeByte(3);
            SnappyBlockEncoding.serialize(output, (SnappyBlockEncoding)encoding);
        } else {
            throw new IllegalArgumentException("unknown encoding " + encoding);
        }
    }
}

