/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.tuple.TupleInfo;

public class CumulativeDistributionFunction
implements WindowFunction {
    private long totalCount;
    private long count;

    @Override
    public TupleInfo getTupleInfo() {
        return TupleInfo.SINGLE_DOUBLE;
    }

    @Override
    public void reset(int partitionRowCount) {
        this.totalCount = partitionRowCount;
        this.count = 0L;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        if (newPeerGroup) {
            this.count += (long)peerGroupCount;
        }
        output.append((double)this.count / (double)this.totalCount);
    }
}

