/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.sql.gen.DefaultFunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.TypedByteCodeNode;
import com.facebook.presto.util.ThreadLocalCache;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RegexpFunctions {
    private static final PatternCache CACHE = new PatternCache(100);

    private RegexpFunctions() {
    }

    @Description(value="returns substrings matching a regular expression")
    @ScalarFunction(functionBinder=RegexFunctionBinder.class)
    public static boolean regexpLike(Slice source, Slice pattern) {
        return RegexpFunctions.regexpLike(CACHE, source, pattern);
    }

    public static boolean regexpLike(PatternCache patternCache, Slice source, Slice pattern) {
        return RegexpFunctions.regexpLike(source, (Pattern)patternCache.get(pattern));
    }

    public static boolean regexpLike(Slice source, Pattern pattern) {
        return pattern.matcher(source.toString(StandardCharsets.UTF_8)).find();
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction(functionBinder=RegexFunctionBinder.class)
    public static Slice regexpReplace(Slice source, Slice pattern) {
        return RegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction(functionBinder=RegexFunctionBinder.class)
    public static Slice regexpReplace(Slice source, Slice pattern, Slice replacement) {
        return RegexpFunctions.regexpReplace(CACHE, source, pattern, replacement);
    }

    public static Slice regexpReplace(PatternCache patternCache, Slice source, Slice pattern, Slice replacement) {
        return RegexpFunctions.regexpReplace(source, (Pattern)patternCache.get(pattern), replacement);
    }

    public static Slice regexpReplace(Slice source, Pattern pattern, Slice replacement) {
        Matcher matcher = pattern.matcher(source.toString(StandardCharsets.UTF_8));
        String replaced = matcher.replaceAll(replacement.toString(StandardCharsets.UTF_8));
        return Slices.copiedBuffer((String)replaced, (Charset)StandardCharsets.UTF_8);
    }

    @Nullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction(functionBinder=RegexFunctionBinder.class)
    public static Slice regexpExtract(Slice source, Slice pattern) {
        return RegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @Nullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction(functionBinder=RegexFunctionBinder.class)
    public static Slice regexpExtract(Slice source, Slice pattern, long group) {
        return RegexpFunctions.regexpExtract(CACHE, source, pattern, group);
    }

    @Nullable
    public static Slice regexpExtract(PatternCache patternCache, Slice source, Slice pattern, long group) {
        return RegexpFunctions.regexpExtract(source, (Pattern)patternCache.get(pattern), group);
    }

    @Nullable
    public static Slice regexpExtract(Slice source, Pattern pattern, long group) {
        Matcher matcher = pattern.matcher(source.toString(StandardCharsets.UTF_8));
        if (group < 0L || group > (long)matcher.groupCount()) {
            throw new IllegalArgumentException("invalid group count");
        }
        if (!matcher.find()) {
            return null;
        }
        String extracted = matcher.group(Ints.checkedCast((long)group));
        return Slices.copiedBuffer((String)extracted, (Charset)StandardCharsets.UTF_8);
    }

    public static class PatternCache
    extends ThreadLocalCache<Slice, Pattern> {
        public PatternCache(int maxSizePerThread) {
            super(maxSizePerThread);
        }

        @Override
        @Nonnull
        protected Pattern load(Slice patternSlice) {
            return Pattern.compile(patternSlice.toString(StandardCharsets.UTF_8));
        }
    }

    public static class RegexFunctionBinder
    implements FunctionBinder {
        private static final MethodHandle constantRegexpLike;
        private static final MethodHandle dynamicRegexpLike;
        private static final MethodHandle constantRegexpReplace;
        private static final MethodHandle dynamicRegexpReplace;
        private static final MethodHandle constantRegexpExtract;
        private static final MethodHandle dynamicRegexpExtract;

        @Override
        public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<TypedByteCodeNode> arguments) {
            MethodHandle methodHandle;
            boolean nullable = false;
            TypedByteCodeNode patternNode = arguments.get(1);
            if (patternNode.getNode() instanceof Constant) {
                switch (name) {
                    case "regexp_like": {
                        methodHandle = constantRegexpLike;
                        break;
                    }
                    case "regexp_replace": {
                        methodHandle = constantRegexpReplace;
                        if (arguments.size() != 2) break;
                        methodHandle = MethodHandles.insertArguments(methodHandle, 2, Slices.EMPTY_SLICE);
                        break;
                    }
                    case "regexp_extract": {
                        methodHandle = constantRegexpExtract;
                        nullable = true;
                        if (arguments.size() != 2) break;
                        methodHandle = MethodHandles.insertArguments(methodHandle, 2, 0L);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported method " + name);
                    }
                }
                Slice patternSlice = (Slice)((Constant)patternNode.getNode()).getValue();
                Pattern pattern = Pattern.compile(patternSlice.toString(StandardCharsets.UTF_8));
                methodHandle = MethodHandles.insertArguments(methodHandle, 1, pattern);
                arguments = new ArrayList<TypedByteCodeNode>((Collection<TypedByteCodeNode>)arguments);
                arguments.remove(1);
                arguments = ImmutableList.copyOf(arguments);
            } else {
                switch (name) {
                    case "regexp_like": {
                        methodHandle = dynamicRegexpLike;
                        break;
                    }
                    case "regexp_replace": {
                        methodHandle = dynamicRegexpReplace;
                        if (arguments.size() != 2) break;
                        methodHandle = MethodHandles.insertArguments(methodHandle, 3, Slices.EMPTY_SLICE);
                        break;
                    }
                    case "regexp_extract": {
                        methodHandle = dynamicRegexpExtract;
                        nullable = true;
                        if (arguments.size() != 2) break;
                        methodHandle = MethodHandles.insertArguments(methodHandle, 3, 0L);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported method " + name);
                    }
                }
                methodHandle = methodHandle.bindTo(new PatternCache(100));
            }
            return DefaultFunctionBinder.bindConstantArguments(bindingId, name, getSessionByteCode, arguments, methodHandle, nullable);
        }

        static {
            try {
                constantRegexpLike = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpLike", MethodType.methodType(Boolean.TYPE, Slice.class, Pattern.class));
                dynamicRegexpLike = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpLike", MethodType.methodType(Boolean.TYPE, PatternCache.class, Slice.class, Slice.class));
                constantRegexpReplace = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpReplace", MethodType.methodType(Slice.class, Slice.class, Pattern.class, Slice.class));
                dynamicRegexpReplace = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpReplace", MethodType.methodType(Slice.class, PatternCache.class, Slice.class, Slice.class, Slice.class));
                constantRegexpExtract = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpExtract", MethodType.methodType(Slice.class, Slice.class, Pattern.class, Long.TYPE));
                dynamicRegexpExtract = MethodHandles.lookup().findStatic(RegexpFunctions.class, "regexpExtract", MethodType.methodType(Slice.class, PatternCache.class, Slice.class, Slice.class, Long.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

