/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.VariableWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.stats.QuantileDigest;
import java.io.DataInput;
import java.io.DataOutput;

public class LongApproximatePercentileWeightedAggregation
implements VariableWidthAggregationFunction<DigestAndPercentile> {
    public static final LongApproximatePercentileWeightedAggregation INSTANCE = new LongApproximatePercentileWeightedAggregation();
    private static final int VALUE_INDEX = 0;
    private static final int WEIGHT_INDEX = 1;
    private static final int PERCENTILE_INDEX = 2;

    @Override
    public DigestAndPercentile initialize() {
        return new DigestAndPercentile(new QuantileDigest(0.01));
    }

    @Override
    public DigestAndPercentile addInput(int positionCount, Block[] blocks, int[] fields, DigestAndPercentile currentValue) {
        BlockCursor valueCursor = blocks[0].cursor();
        BlockCursor weightCursor = blocks[1].cursor();
        int valueField = fields[0];
        int weightField = fields[1];
        while (valueCursor.advanceNextPosition() && weightCursor.advanceNextPosition()) {
            if (valueCursor.isNull(valueField) || weightCursor.isNull(weightField)) continue;
            long value = valueCursor.getLong(valueField);
            long weight = weightCursor.getLong(weightField);
            currentValue.digest.add(value, weight);
        }
        BlockCursor percentileCursor = blocks[2].cursor();
        int percentileField = fields[2];
        if (percentileCursor.advanceNextPosition() && !percentileCursor.isNull(percentileField)) {
            currentValue.percentile = percentileCursor.getDouble(percentileField);
        }
        return currentValue;
    }

    @Override
    public DigestAndPercentile addInput(BlockCursor[] cursors, int[] fields, DigestAndPercentile currentValue) {
        if (!cursors[0].isNull(fields[0]) && !cursors[1].isNull(fields[1])) {
            long value = cursors[0].getLong(fields[0]);
            long weight = cursors[1].getLong(fields[1]);
            currentValue.digest.add(value, weight);
        }
        if (!cursors[2].isNull(fields[2])) {
            currentValue.percentile = cursors[2].getDouble(fields[2]);
        }
        return currentValue;
    }

    @Override
    public DigestAndPercentile addIntermediate(BlockCursor[] cursors, int[] fields, DigestAndPercentile currentValue) {
        if (!cursors[0].isNull(fields[0])) {
            BasicSliceInput input = cursors[0].getSlice(fields[0]).getInput();
            currentValue.digest.merge(QuantileDigest.deserialize((DataInput)input));
            currentValue.percentile = input.readDouble();
        }
        return currentValue;
    }

    @Override
    public void evaluateIntermediate(DigestAndPercentile currentValue, BlockBuilder output) {
        if (currentValue.digest.getCount() == 0.0) {
            output.appendNull();
        } else {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(currentValue.digest.estimatedSerializedSizeInBytes());
            currentValue.digest.serialize((DataOutput)sliceOutput);
            sliceOutput.appendDouble(currentValue.percentile);
            output.append(sliceOutput.slice());
        }
    }

    @Override
    public void evaluateFinal(DigestAndPercentile currentValue, BlockBuilder output) {
        if (currentValue.digest.getCount() == 0.0) {
            output.appendNull();
        } else {
            Preconditions.checkState((currentValue.percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            output.append(currentValue.digest.getQuantile(currentValue.percentile));
        }
    }

    @Override
    public long estimateSizeInBytes(DigestAndPercentile value) {
        return value.digest.estimatedInMemorySizeInBytes();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_VARBINARY;
    }

    public static final class DigestAndPercentile {
        private QuantileDigest digest;
        private double percentile = -1.0;

        public DigestAndPercentile(QuantileDigest digest) {
            this.digest = digest;
        }
    }
}

