/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;

public class CountColumnAggregation
implements FixedWidthAggregationFunction {
    public static final CountColumnAggregation COUNT_COLUMN = new CountColumnAggregation();

    @Override
    public int getFixedSize() {
        return TupleInfo.SINGLE_LONG.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, 0L);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, currentValue + 1L);
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        long count = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            ++count;
        }
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, count);
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        long newValue = cursor.getLong(field);
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, currentValue + newValue);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        this.evaluateFinal(valueSlice, valueOffset, output);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        output.append(currentValue);
    }
}

