/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;

public class CountAggregation
implements FixedWidthAggregationFunction {
    public static final CountAggregation COUNT = new CountAggregation();

    @Override
    public int getFixedSize() {
        return TupleInfo.SINGLE_LONG.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_LONG;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        this.addCount(positionCount, valueSlice, valueOffset);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        this.addCount(1, valueSlice, valueOffset);
    }

    private void addCount(int positionCount, Slice valueSlice, int valueOffset) {
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, currentValue + (long)positionCount);
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(0)) {
            return;
        }
        long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
        long newValue = cursor.getLong(0);
        TupleInfo.SINGLE_LONG.setLong(valueSlice, valueOffset, 0, currentValue + newValue);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        this.evaluateFinal(valueSlice, valueOffset, output);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TupleInfo.SINGLE_LONG.isNull(valueSlice, valueOffset, 0)) {
            long currentValue = TupleInfo.SINGLE_LONG.getLong(valueSlice, valueOffset, 0);
            output.append(currentValue);
        } else {
            output.appendNull();
        }
    }
}

