/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.Block;
import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.block.BlockCursor;
import com.facebook.presto.operator.aggregation.FixedWidthAggregationFunction;
import com.facebook.presto.tuple.TupleInfo;
import io.airlift.slice.Slice;

public class BooleanMinAggregation
implements FixedWidthAggregationFunction {
    public static final BooleanMinAggregation BOOLEAN_MIN = new BooleanMinAggregation();

    @Override
    public int getFixedSize() {
        return TupleInfo.SINGLE_BOOLEAN.getFixedSize();
    }

    @Override
    public TupleInfo getFinalTupleInfo() {
        return TupleInfo.SINGLE_BOOLEAN;
    }

    @Override
    public TupleInfo getIntermediateTupleInfo() {
        return TupleInfo.SINGLE_BOOLEAN;
    }

    @Override
    public void initialize(Slice valueSlice, int valueOffset) {
        TupleInfo.SINGLE_BOOLEAN.setNull(valueSlice, valueOffset, 0);
        TupleInfo.SINGLE_BOOLEAN.setBoolean(valueSlice, valueOffset, 0, Boolean.TRUE);
    }

    @Override
    public void addInput(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        if (cursor.isNull(field)) {
            return;
        }
        TupleInfo.SINGLE_BOOLEAN.setNotNull(valueSlice, valueOffset, 0);
        boolean newValue = cursor.getBoolean(field);
        if (!newValue) {
            TupleInfo.SINGLE_BOOLEAN.setBoolean(valueSlice, valueOffset, 0, false);
        }
    }

    @Override
    public void addInput(int positionCount, Block block, int field, Slice valueSlice, int valueOffset) {
        boolean hasNonNull;
        boolean bl = hasNonNull = !TupleInfo.SINGLE_BOOLEAN.isNull(valueSlice, valueOffset);
        if (hasNonNull && !TupleInfo.SINGLE_BOOLEAN.getBoolean(valueSlice, valueOffset, field)) {
            return;
        }
        boolean min = true;
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (cursor.isNull(field)) continue;
            hasNonNull = true;
            if (cursor.getBoolean(field)) continue;
            min = false;
            break;
        }
        if (hasNonNull) {
            TupleInfo.SINGLE_BOOLEAN.setNotNull(valueSlice, valueOffset, 0);
            TupleInfo.SINGLE_BOOLEAN.setBoolean(valueSlice, valueOffset, 0, min);
        }
    }

    @Override
    public void addIntermediate(BlockCursor cursor, int field, Slice valueSlice, int valueOffset) {
        this.addInput(cursor, field, valueSlice, valueOffset);
    }

    @Override
    public void evaluateIntermediate(Slice valueSlice, int valueOffset, BlockBuilder output) {
        this.evaluateFinal(valueSlice, valueOffset, output);
    }

    @Override
    public void evaluateFinal(Slice valueSlice, int valueOffset, BlockBuilder output) {
        if (!TupleInfo.SINGLE_BOOLEAN.isNull(valueSlice, valueOffset, 0)) {
            boolean currentValue = TupleInfo.SINGLE_BOOLEAN.getBoolean(valueSlice, valueOffset, 0);
            output.append(currentValue);
        } else {
            output.appendNull();
        }
    }
}

